/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl;

import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl.AnnotationProcessorProvider;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl.PropertyAnnotationProcessor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl.TypeAnnotationProcessor;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingContext;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl.TypeMappingContextImpl;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;

class AnnotationPojoTypeMetadataContributorFactory {
    private final AnnotationProcessorProvider annotationProcessorProvider;

    AnnotationPojoTypeMetadataContributorFactory(AnnotationProcessorProvider annotationProcessorProvider) {
        this.annotationProcessorProvider = annotationProcessorProvider;
    }

    public PojoTypeMetadataContributor create(PojoRawTypeModel<?> typeModel) {
        TypeMappingContextImpl typeMappingContext = new TypeMappingContextImpl(typeModel);
        this.processTypeLevelAnnotations(typeMappingContext, typeModel);
        typeModel.getDeclaredProperties().forEach(propertyModel -> this.processPropertyLevelAnnotations(typeMappingContext, typeModel, (PojoPropertyModel<?>)propertyModel));
        return typeMappingContext;
    }

    private void processTypeLevelAnnotations(TypeMappingContextImpl typeMappingContext, PojoRawTypeModel<?> typeModel) {
        for (TypeAnnotationProcessor<?> processor : this.annotationProcessorProvider.getTypeAnnotationProcessors()) {
            processor.process(typeMappingContext, typeModel);
        }
    }

    private void processPropertyLevelAnnotations(TypeMappingContextImpl typeMappingContext, PojoRawTypeModel<?> typeModel, PojoPropertyModel<?> propertyModel) {
        String propertyName = propertyModel.getName();
        PropertyMappingContext mappingContext = typeMappingContext.property(propertyName);
        for (PropertyAnnotationProcessor<?> processor : this.annotationProcessorProvider.getPropertyAnnotationProcessors()) {
            processor.process(mappingContext, typeModel, propertyModel);
        }
    }
}

