/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl.AnnotationProcessorHelper;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingContext;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.reporting.impl.PojoEventContexts;

abstract class PropertyAnnotationProcessor<A extends Annotation> {
    final AnnotationProcessorHelper helper;

    PropertyAnnotationProcessor(AnnotationProcessorHelper helper) {
        this.helper = helper;
    }

    public final void process(PropertyMappingContext mappingContext, PojoRawTypeModel<?> typeModel, PojoPropertyModel<?> propertyModel) {
        this.processEach(mappingContext, typeModel, propertyModel, this.extractAnnotations(propertyModel));
    }

    abstract Stream<? extends A> extractAnnotations(PojoPropertyModel<?> var1);

    abstract void doProcess(PropertyMappingContext var1, PojoRawTypeModel<?> var2, PojoPropertyModel<?> var3, A var4);

    private void processEach(PropertyMappingContext mappingContext, PojoRawTypeModel<?> typeModel, PojoPropertyModel<?> propertyModel, Stream<? extends A> annotations) {
        List annotationList = annotations.collect(Collectors.toList());
        for (Annotation annotation : annotationList) {
            try {
                this.doProcess(mappingContext, typeModel, propertyModel, annotation);
            }
            catch (RuntimeException e) {
                this.helper.getRootFailureCollector().withContext(PojoEventContexts.fromType(typeModel)).withContext(PojoEventContexts.fromPath(PojoModelPath.ofProperty(propertyModel.getName()))).withContext(PojoEventContexts.fromAnnotation(annotation)).add((Throwable)e);
            }
        }
    }
}

