/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.impl;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.index.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.index.spi.IndexDocumentWorkExecutor;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;

public class PojoTypeDocumentWorkExecutor<I, E, D extends DocumentElement> {
    private final AbstractPojoSessionContextImplementor sessionContext;
    private final PojoIndexedTypeManager<I, E, D> typeManager;
    private final IndexDocumentWorkExecutor<D> delegate;

    public PojoTypeDocumentWorkExecutor(PojoIndexedTypeManager<I, E, D> typeManager, AbstractPojoSessionContextImplementor sessionContext, IndexDocumentWorkExecutor<D> delegate) {
        this.sessionContext = sessionContext;
        this.typeManager = typeManager;
        this.delegate = delegate;
    }

    public CompletableFuture<?> add(Object providedId, Object entity) {
        Supplier<E> entitySupplier = this.typeManager.toEntitySupplier(this.sessionContext, entity);
        I identifier = this.typeManager.getIdentifierMapping().getIdentifier(providedId, entitySupplier);
        DocumentReferenceProvider referenceProvider = this.typeManager.toDocumentReferenceProvider(this.sessionContext, identifier, entitySupplier);
        return this.delegate.add(referenceProvider, this.typeManager.toDocumentContributor(entitySupplier, this.sessionContext));
    }
}

