/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.path.impl;

import org.hibernate.search.mapper.pojo.extractor.impl.BoundContainerExtractorPath;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PropertyHandle;

public class BoundPojoModelPathPropertyNode<T, P>
extends BoundPojoModelPath {
    private final BoundPojoModelPathTypeNode<T> parent;
    private final PropertyHandle<P> propertyHandle;
    private final PojoPropertyModel<P> propertyModel;

    BoundPojoModelPathPropertyNode(BoundPojoModelPathTypeNode<T> parent, PojoPropertyModel<P> propertyModel) {
        this.parent = parent;
        this.propertyModel = propertyModel;
        this.propertyHandle = propertyModel.getHandle();
    }

    @Override
    public BoundPojoModelPathTypeNode<T> getParent() {
        return this.parent;
    }

    @Override
    public PojoTypeModel<?> getRootType() {
        return this.parent.getRootType();
    }

    @Override
    public PojoModelPathPropertyNode toUnboundPath() {
        PojoModelPath.Builder builder = PojoModelPath.builder();
        this.appendPath(builder);
        return builder.toPropertyPathOrNull();
    }

    public BoundPojoModelPathValueNode<T, P, P> valueWithoutExtractors() {
        return this.value(BoundContainerExtractorPath.noExtractors(this.propertyModel.getTypeModel()));
    }

    public <V> BoundPojoModelPathValueNode<T, P, V> value(BoundContainerExtractorPath<P, V> extractorPath) {
        return new BoundPojoModelPathValueNode(this, extractorPath);
    }

    public PropertyHandle<P> getPropertyHandle() {
        return this.propertyHandle;
    }

    public PojoPropertyModel<P> getPropertyModel() {
        return this.propertyModel;
    }

    @Override
    void appendSelfPath(StringBuilder builder) {
        builder.append(".").append(this.propertyHandle.getName());
    }

    @Override
    void appendSelfPath(PojoModelPath.Builder builder) {
        builder.property(this.propertyHandle.getName());
    }
}

