/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.spi;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Member;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.spi.PropertyHandle;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class MethodHandlePropertyHandle<T>
implements PropertyHandle<T> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String name;
    private final Member member;
    private final MethodHandle getter;

    public MethodHandlePropertyHandle(String name, Member member, MethodHandle getter) {
        this.name = name;
        this.member = member;
        this.getter = getter;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.member + "]";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T get(Object thiz) {
        try {
            return (T)this.getter.invoke(thiz);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw log.errorInvokingMember(this.member, thiz, e);
        }
    }

    @Override
    public int hashCode() {
        return this.member.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        MethodHandlePropertyHandle other = (MethodHandlePropertyHandle)obj;
        return this.name.equals(other.name) && this.member.equals(other.member);
    }
}

