/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.sql.Timestamp;
import java.time.Instant;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentFieldValueConvertContext;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeContext;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.ValueBridgeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;

public final class DefaultJavaSqlTimestampValueBridge
implements ValueBridge<Timestamp, Instant> {
    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public StandardIndexFieldTypeContext<?, Instant> bind(ValueBridgeBindingContext<Timestamp> context) {
        return (StandardIndexFieldTypeContext)context.getTypeFactory().asInstant().projectionConverter((FromDocumentFieldValueConverter)PojoDefaultSqlDateFromDocumentFieldValueConverter.INSTANCE);
    }

    @Override
    public Instant toIndexedValue(Timestamp value, ValueBridgeToIndexedValueContext context) {
        return value == null ? null : Instant.ofEpochMilli(value.getTime());
    }

    @Override
    public Timestamp cast(Object value) {
        return (Timestamp)value;
    }

    @Override
    public Instant parse(String value) {
        return ParseUtils.parseInstant((String)value);
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        return this.getClass().equals(other.getClass());
    }

    private static class PojoDefaultSqlDateFromDocumentFieldValueConverter
    implements FromDocumentFieldValueConverter<Instant, Timestamp> {
        private static final PojoDefaultSqlDateFromDocumentFieldValueConverter INSTANCE = new PojoDefaultSqlDateFromDocumentFieldValueConverter();

        private PojoDefaultSqlDateFromDocumentFieldValueConverter() {
        }

        public boolean isConvertedTypeAssignableTo(Class<?> superTypeCandidate) {
            return superTypeCandidate.isAssignableFrom(Timestamp.class);
        }

        public Timestamp convert(Instant value, FromDocumentFieldValueConvertContext context) {
            return value == null ? null : new Timestamp(value.toEpochMilli());
        }

        public boolean isCompatibleWith(FromDocumentFieldValueConverter<?, ?> other) {
            return INSTANCE.equals(other);
        }
    }
}

