/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.time.Period;
import java.util.Locale;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentFieldValueConvertContext;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeContext;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.ValueBridgeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class DefaultPeriodValueBridge
implements ValueBridge<Period, String> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final int PADDING = 11;
    private static final String FORMAT = "%+011d%+011d%+011d";

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public StandardIndexFieldTypeContext<?, String> bind(ValueBridgeBindingContext<Period> context) {
        return (StandardIndexFieldTypeContext)context.getTypeFactory().asString().projectionConverter((FromDocumentFieldValueConverter)PojoDefaultPeriodFromDocumentFieldValueConverter.INSTANCE);
    }

    @Override
    public String toIndexedValue(Period value, ValueBridgeToIndexedValueContext context) {
        return this.toIndexedValue(value);
    }

    @Override
    public Period cast(Object value) {
        return (Period)value;
    }

    @Override
    public String parse(String value) {
        return this.toIndexedValue(ParseUtils.parsePeriod((String)value));
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        return this.getClass().equals(other.getClass());
    }

    private String toIndexedValue(Period value) {
        if (value == null) {
            return null;
        }
        return String.format(Locale.ROOT, FORMAT, value.getYears(), value.getMonths(), value.getDays());
    }

    private static class PojoDefaultPeriodFromDocumentFieldValueConverter
    implements FromDocumentFieldValueConverter<String, Period> {
        private static final PojoDefaultPeriodFromDocumentFieldValueConverter INSTANCE = new PojoDefaultPeriodFromDocumentFieldValueConverter();

        private PojoDefaultPeriodFromDocumentFieldValueConverter() {
        }

        public boolean isConvertedTypeAssignableTo(Class<?> superTypeCandidate) {
            return superTypeCandidate.isAssignableFrom(Period.class);
        }

        public Period convert(String value, FromDocumentFieldValueConvertContext context) {
            if (value == null) {
                return null;
            }
            try {
                int years = Integer.parseInt(value.substring(0, 11));
                int months = Integer.parseInt(value.substring(11, 22));
                int days = Integer.parseInt(value.substring(22));
                return Period.of(years, months, days);
            }
            catch (NumberFormatException e) {
                throw log.parseException(value, Duration.class, e);
            }
        }

        public boolean isCompatibleWith(FromDocumentFieldValueConverter<?, ?> other) {
            return INSTANCE.equals(other);
        }
    }
}

