/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.mapping.impl;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.AnnotationBridgeBuilder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.BridgeBuildContext;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.BridgeBuilder;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.impl.GenericTypeContext;
import org.hibernate.search.util.common.reflect.impl.ReflectionUtils;

public final class AnnotationInitializingBeanDelegatingBridgeBuilder<B, A extends Annotation>
implements BridgeBuilder<B> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final BeanReference<? extends AnnotationBridgeBuilder> delegateReference;
    private final Class<B> expectedBridgeType;
    private final A annotation;

    public AnnotationInitializingBeanDelegatingBridgeBuilder(BeanReference<? extends AnnotationBridgeBuilder> delegateReference, Class<B> expectedBridgeType, A annotation) {
        this.delegateReference = delegateReference;
        this.expectedBridgeType = expectedBridgeType;
        this.annotation = annotation;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[delegateReference=" + this.delegateReference + ", annotation=" + this.annotation + "]";
    }

    @Override
    public BeanHolder<? extends B> build(BridgeBuildContext buildContext) {
        BeanHolder<?> bridgeHolder;
        try (BeanHolder delegateHolder = this.delegateReference.resolve(buildContext.getBeanResolver());){
            bridgeHolder = this.doBuild(buildContext, (AnnotationBridgeBuilder)delegateHolder.get());
        }
        this.expectedBridgeType.cast(bridgeHolder.get());
        BeanHolder<?> castedBridgeHolder = bridgeHolder;
        return castedBridgeHolder;
    }

    private BeanHolder<?> doBuild(BridgeBuildContext buildContext, AnnotationBridgeBuilder<?, ?> delegate) {
        Class<? extends Annotation> annotationType = this.annotation.annotationType();
        GenericTypeContext bridgeTypeContext = new GenericTypeContext(delegate.getClass());
        Class builderAnnotationType = bridgeTypeContext.resolveTypeArgument(AnnotationBridgeBuilder.class, 1).map(ReflectionUtils::getRawType).orElseThrow(() -> new AssertionFailure("Could not auto-detect the annotation type accepted by builder '" + delegate + "'. There is a bug in Hibernate Search, please report it."));
        if (!builderAnnotationType.isAssignableFrom(annotationType)) {
            throw log.invalidAnnotationTypeForBuilder(delegate, annotationType);
        }
        AnnotationBridgeBuilder<?, ?> castedDelegate = delegate;
        castedDelegate.initialize(this.annotation);
        return castedDelegate.build(buildContext);
    }
}

