/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.mapping.impl;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.AnnotationMarkerBuilder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.MarkerBuildContext;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.MarkerBuilder;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.impl.GenericTypeContext;
import org.hibernate.search.util.common.reflect.impl.ReflectionUtils;

public final class AnnotationInitializingBeanDelegatingMarkerBuilder<A extends Annotation>
implements MarkerBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final BeanReference<? extends AnnotationMarkerBuilder> delegateReference;
    private final A annotation;

    public AnnotationInitializingBeanDelegatingMarkerBuilder(BeanReference<? extends AnnotationMarkerBuilder> delegateReference, A annotation) {
        this.delegateReference = delegateReference;
        this.annotation = annotation;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[delegateReference=" + this.delegateReference + ", annotation=" + this.annotation + "]";
    }

    @Override
    public Object build(MarkerBuildContext buildContext) {
        try (BeanHolder delegateHolder = this.delegateReference.resolve(buildContext.getBeanResolver());){
            Object object = this.doBuild(buildContext, (AnnotationMarkerBuilder)delegateHolder.get());
            return object;
        }
    }

    private Object doBuild(MarkerBuildContext buildContext, AnnotationMarkerBuilder<?> delegate) {
        Class<? extends Annotation> annotationType = this.annotation.annotationType();
        GenericTypeContext bridgeTypeContext = new GenericTypeContext(delegate.getClass());
        Class builderAnnotationType = bridgeTypeContext.resolveTypeArgument(AnnotationMarkerBuilder.class, 0).map(ReflectionUtils::getRawType).orElseThrow(() -> new AssertionFailure("Could not auto-detect the annotation type accepted by builder '" + delegate + "'. There is a bug in Hibernate Search, please report it."));
        if (!builderAnnotationType.isAssignableFrom(annotationType)) {
            throw log.invalidAnnotationTypeForBuilder(delegate, annotationType);
        }
        AnnotationMarkerBuilder<?> castedDelegate = delegate;
        castedDelegate.initialize(this.annotation);
        return castedDelegate.build(buildContext);
    }
}

