/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.mapping.impl;

import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.BridgeBuildContext;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.BridgeBuilder;

public final class BeanDelegatingBridgeBuilder<B>
implements BridgeBuilder<B> {
    private final BeanReference<? extends BridgeBuilder> delegateReference;
    private final Class<B> expectedBridgeType;

    public BeanDelegatingBridgeBuilder(BeanReference<? extends BridgeBuilder> delegateReference, Class<B> expectedBridgeType) {
        this.delegateReference = delegateReference;
        this.expectedBridgeType = expectedBridgeType;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[delegateReference=" + this.delegateReference + "]";
    }

    @Override
    public BeanHolder<? extends B> build(BridgeBuildContext buildContext) {
        BeanHolder bridgeHolder;
        try (BeanHolder delegateHolder = this.delegateReference.resolve(buildContext.getBeanResolver());){
            bridgeHolder = ((BridgeBuilder)delegateHolder.get()).build(buildContext);
        }
        this.expectedBridgeType.cast(bridgeHolder.get());
        BeanHolder castedBridgeHolder = bridgeHolder;
        return castedBridgeHolder;
    }
}

