/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.dirtiness.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.hibernate.search.mapper.pojo.dirtiness.ReindexOnUpdate;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.AbstractPojoImplicitReindexingResolverTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.AbstractPojoIndexingDependencyCollectorValueNode;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoImplicitReindexingResolverBuilder;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoImplicitReindexingResolverValueNodeBuilderDelegate;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoIndexingDependencyCollectorTypeNode;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.binding.impl.PojoModelPathBinder;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoIndexingDependencyCollectorDisjointValueNode<V>
extends AbstractPojoIndexingDependencyCollectorValueNode {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoIndexingDependencyCollectorTypeNode<?> parentNode;
    private final PojoRawTypeModel<V> inverseSideEntityTypeModel;
    private final BoundPojoModelPathValueNode<?, ?, ?> inverseAssociationPath;

    PojoIndexingDependencyCollectorDisjointValueNode(PojoIndexingDependencyCollectorTypeNode<?> parentNode, PojoRawTypeModel<V> inverseSideEntityTypeModel, BoundPojoModelPathValueNode<?, ?, ?> inverseAssociationPath, PojoImplicitReindexingResolverBuildingHelper buildingHelper) {
        super(buildingHelper);
        this.parentNode = parentNode;
        this.inverseSideEntityTypeModel = inverseSideEntityTypeModel;
        this.inverseAssociationPath = inverseAssociationPath;
        if (!buildingHelper.isEntity(inverseSideEntityTypeModel)) {
            throw new AssertionFailure("Encountered a type node whose parent is a disjoint value node, but does not represent an entity type?");
        }
        if (!inverseAssociationPath.getRootType().equals(inverseSideEntityTypeModel)) {
            throw new AssertionFailure("Inconsistent root type for " + inverseAssociationPath + "; expected " + inverseSideEntityTypeModel);
        }
    }

    public PojoIndexingDependencyCollectorTypeNode<?> type() {
        return new PojoIndexingDependencyCollectorTypeNode<V>(this, this.inverseSideEntityTypeModel, this.buildingHelper);
    }

    @Override
    ReindexOnUpdate getReindexOnUpdate() {
        return this.parentNode.getReindexOnUpdate();
    }

    @Override
    void markForReindexing(AbstractPojoImplicitReindexingResolverTypeNodeBuilder<?, ?> inverseSideEntityTypeNodeBuilder, BoundPojoModelPathValueNode<?, ?, ?> dependencyPathFromInverseSideEntityTypeNode) {
        Set<PojoRawTypeModel<?>> valueNodeTypeConcreteEntitySubTypes;
        PojoImplicitReindexingResolverValueNodeBuilderDelegate valueNodeBuilderDelegate;
        PojoTypeModel<?> inverseSideEntityType = inverseSideEntityTypeNodeBuilder.getTypeModel();
        PojoRawTypeModel<?> inverseSideRawEntityType = inverseSideEntityType.getRawType();
        PojoRawTypeModel<?> originalSideRawConcreteEntityType = this.parentNode.getTypeModel().getRawType();
        PojoModelPathValueNode inverseAssociationUnboundPath = this.inverseAssociationPath.toUnboundPath();
        try {
            valueNodeBuilderDelegate = (PojoImplicitReindexingResolverValueNodeBuilderDelegate)PojoModelPathBinder.bind(inverseSideEntityTypeNodeBuilder, inverseAssociationUnboundPath, PojoImplicitReindexingResolverBuilder.walker());
            PojoRawTypeModel inverseSideRawType = valueNodeBuilderDelegate.getTypeModel().getRawType();
            valueNodeTypeConcreteEntitySubTypes = this.parentNode.getConcreteEntitySubTypesForTypeToReindex(originalSideRawConcreteEntityType, inverseSideRawType);
        }
        catch (RuntimeException e) {
            throw log.cannotApplyExplicitInverseAssociationPath(inverseSideRawEntityType, inverseAssociationUnboundPath, originalSideRawConcreteEntityType, e.getMessage(), e);
        }
        this.parentNode.markForReindexing(valueNodeBuilderDelegate, valueNodeTypeConcreteEntitySubTypes, dependencyPathFromInverseSideEntityTypeNode);
    }
}

