/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexManagerBuildingState;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.RoutingKeyBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.IdentifierMappingImplementor;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.PropertyIdentifierMapping;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.ProvidedStringIdentifierMapping;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.RoutingKeyBridgeRoutingKeyProvider;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.RoutingKeyProvider;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.BridgeBuilder;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.building.impl.BoundRoutingKeyBridge;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathTypeNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.processing.building.impl.PojoIdentityMappingCollector;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class PojoIdentityMappingCollectorImpl<E>
implements PojoIdentityMappingCollector {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoRawTypeModel<E> typeModel;
    private final PojoMappingHelper mappingHelper;
    private final IndexManagerBuildingState<?> indexManagerBuildingState;
    private final boolean implicitProvidedId;
    private final BoundPojoModelPathPropertyNode<?, ?> entityIdPropertyPath;
    IdentifierMappingImplementor<?, E> identifierMapping;
    Optional<String> documentIdSourcePropertyName;
    RoutingKeyProvider<E> routingKeyProvider;

    PojoIdentityMappingCollectorImpl(PojoRawTypeModel<E> typeModel, PojoTypeAdditionalMetadata typeAdditionalMetadata, PojoMappingHelper mappingHelper, IndexManagerBuildingState<?> indexManagerBuildingState, boolean implicitProvidedId) {
        this.typeModel = typeModel;
        this.mappingHelper = mappingHelper;
        this.indexManagerBuildingState = indexManagerBuildingState;
        this.implicitProvidedId = implicitProvidedId;
        Optional<String> entityIdPropertyName = typeAdditionalMetadata.getEntityTypeMetadata().orElseThrow(() -> log.missingEntityTypeMetadata(typeModel)).getEntityIdPropertyName();
        this.entityIdPropertyPath = entityIdPropertyName.isPresent() ? BoundPojoModelPath.root(typeModel).property(entityIdPropertyName.get()) : null;
    }

    void closeOnFailure() {
        try (Closer closer = new Closer();){
            closer.push(IdentifierMappingImplementor::close, this.identifierMapping);
            closer.push(RoutingKeyProvider::close, this.routingKeyProvider);
        }
    }

    @Override
    public <T> void identifierBridge(BoundPojoModelPathPropertyNode<?, T> modelPath, BridgeBuilder<? extends IdentifierBridge<?>> builder) {
        BeanHolder<IdentifierBridge<T>> bridgeHolder = this.mappingHelper.getIndexModelBinder().addIdentifierBridge(this.indexManagerBuildingState.getIndexedEntityBindingContext(), modelPath, builder);
        PojoPropertyModel<T> propertyModel = modelPath.getPropertyModel();
        this.identifierMapping = new PropertyIdentifierMapping(propertyModel.getTypeModel().getRawType().getCaster(), propertyModel.getHandle(), bridgeHolder);
        this.documentIdSourcePropertyName = Optional.of(propertyModel.getName());
    }

    @Override
    public <T> BoundRoutingKeyBridge<T> routingKeyBridge(BoundPojoModelPathTypeNode<T> modelPath, BridgeBuilder<? extends RoutingKeyBridge> builder) {
        BoundRoutingKeyBridge<T> boundRoutingKeyBridge = this.mappingHelper.getIndexModelBinder().addRoutingKeyBridge(this.indexManagerBuildingState.getIndexedEntityBindingContext(), modelPath, builder);
        this.routingKeyProvider = new RoutingKeyBridgeRoutingKeyProvider(boundRoutingKeyBridge.getBridgeHolder());
        return boundRoutingKeyBridge;
    }

    void applyDefaults() {
        if (this.identifierMapping == null) {
            if (this.implicitProvidedId) {
                this.identifierMapping = ProvidedStringIdentifierMapping.get();
                this.documentIdSourcePropertyName = Optional.empty();
            } else if (this.entityIdPropertyPath != null) {
                this.identifierBridge(this.entityIdPropertyPath, null);
            } else {
                throw log.missingIdentifierMapping(this.typeModel);
            }
        }
        if (this.routingKeyProvider == null) {
            this.routingKeyProvider = RoutingKeyProvider.alwaysNull();
        }
    }
}

