/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.building.impl;

import java.util.Optional;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentFieldValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentFieldValueConvertContextExtension;
import org.hibernate.search.engine.mapper.mapping.context.spi.MappingContextImplementor;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;
import org.hibernate.search.mapper.pojo.mapping.context.spi.AbstractPojoMappingContextImplementor;

final class PojoValueBridgeToDocumentFieldValueConverter<U, V extends U, F>
implements ToDocumentFieldValueConverter<V, F> {
    private final ValueBridge<U, F> bridge;

    PojoValueBridgeToDocumentFieldValueConverter(ValueBridge<U, F> bridge) {
        this.bridge = bridge;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.bridge + "]";
    }

    public F convert(V value, ToDocumentFieldValueConvertContext context) {
        return this.bridge.toIndexedValue(value, (ValueBridgeToIndexedValueContext)context.extension((ToDocumentFieldValueConvertContextExtension)PojoValueBridgeContextExtension.INSTANCE));
    }

    public F convertUnknown(Object value, ToDocumentFieldValueConvertContext context) {
        return this.bridge.toIndexedValue(this.bridge.cast(value), (ValueBridgeToIndexedValueContext)context.extension((ToDocumentFieldValueConvertContextExtension)PojoValueBridgeContextExtension.INSTANCE));
    }

    public boolean isCompatibleWith(ToDocumentFieldValueConverter<?, ?> other) {
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        PojoValueBridgeToDocumentFieldValueConverter castedOther = (PojoValueBridgeToDocumentFieldValueConverter)other;
        return this.bridge.isCompatibleWith(castedOther.bridge);
    }

    private static class PojoValueBridgeContextExtension
    implements ToDocumentFieldValueConvertContextExtension<ValueBridgeToIndexedValueContext> {
        private static final PojoValueBridgeContextExtension INSTANCE = new PojoValueBridgeContextExtension();

        private PojoValueBridgeContextExtension() {
        }

        public Optional<ValueBridgeToIndexedValueContext> extendOptional(ToDocumentFieldValueConvertContext original, MappingContextImplementor mappingContext) {
            if (mappingContext instanceof AbstractPojoMappingContextImplementor) {
                AbstractPojoMappingContextImplementor pojoMappingContext = (AbstractPojoMappingContextImplementor)mappingContext;
                return Optional.of(pojoMappingContext.getToIndexedValueContext());
            }
            return Optional.empty();
        }
    }
}

