/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Optional;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.PropertyBridge;
import org.hibernate.search.mapper.pojo.bridge.RoutingKeyBridge;
import org.hibernate.search.mapper.pojo.bridge.TypeBridge;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.IdentifierBridgeRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.MarkerRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.PropertyBridgeRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.RoutingKeyBridgeRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.TypeBridgeRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.ValueBridgeRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.declaration.MarkerMapping;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.declaration.PropertyBridgeMapping;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.declaration.RoutingKeyBridgeMapping;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.declaration.TypeBridgeMapping;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.AnnotationInitializingBeanDelegatingBridgeBuilder;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.AnnotationInitializingBeanDelegatingMarkerBuilder;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.BeanBridgeBuilder;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.BeanDelegatingBridgeBuilder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.AnnotationBridgeBuilder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.AnnotationMarkerBuilder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.BridgeBuilder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.MarkerBuilder;
import org.hibernate.search.mapper.pojo.extractor.mapping.annotation.ContainerExtract;
import org.hibernate.search.mapper.pojo.extractor.mapping.annotation.ContainerExtraction;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.DocumentId;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.ObjectPath;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.PropertyValue;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class AnnotationProcessorHelper {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final FailureCollector rootFailureCollector;

    AnnotationProcessorHelper(FailureCollector rootFailureCollector) {
        this.rootFailureCollector = rootFailureCollector;
    }

    FailureCollector getRootFailureCollector() {
        return this.rootFailureCollector;
    }

    Optional<PojoModelPathValueNode> getPojoModelPathValueNode(ObjectPath objectPath) {
        PropertyValue[] inversePathElements = objectPath.value();
        PojoModelPath.Builder inversePathBuilder = PojoModelPath.builder();
        for (PropertyValue element : inversePathElements) {
            String inversePropertyName = element.propertyName();
            ContainerExtractorPath inverseExtractorPath = this.getExtractorPath(element.extraction());
            inversePathBuilder.property(inversePropertyName).value(inverseExtractorPath);
        }
        return Optional.ofNullable(inversePathBuilder.toValuePathOrNull());
    }

    ContainerExtractorPath getExtractorPath(ContainerExtraction extraction) {
        ContainerExtract extract = extraction.extract();
        String[] extractors = extraction.value();
        switch (extract) {
            case NO: {
                if (extractors.length != 0) {
                    throw log.cannotReferenceExtractorsWhenExtractionDisabled();
                }
                return ContainerExtractorPath.noExtractors();
            }
            case DEFAULT: {
                if (extractors.length == 0) {
                    return ContainerExtractorPath.defaultExtractors();
                }
                return ContainerExtractorPath.explicitExtractors(Arrays.asList(extractors));
            }
        }
        throw new AssertionFailure("Unexpected " + ContainerExtract.class.getSimpleName() + " value: " + (Object)((Object)extract));
    }

    <A extends Annotation> MarkerBuilder createMarkerBuilder(A annotation) {
        MarkerMapping markerMapping = annotation.annotationType().getAnnotation(MarkerMapping.class);
        MarkerRef markerBuilderReferenceAnnotation = markerMapping.marker();
        return new AnnotationInitializingBeanDelegatingMarkerBuilder<A>(this.toBeanReference(AnnotationMarkerBuilder.class, MarkerRef.UndefinedBuilderImplementationType.class, markerBuilderReferenceAnnotation.builderType(), markerBuilderReferenceAnnotation.builderName()).orElseThrow(() -> log.missingBuilderReferenceInMarkerMapping(MarkerMapping.class, annotation.annotationType())), annotation);
    }

    BridgeBuilder<? extends IdentifierBridge<?>> createIdentifierBridgeBuilder(DocumentId annotation, PojoPropertyModel<?> annotationHolder) {
        IdentifierBridgeRef bridgeReferenceAnnotation = annotation.identifierBridge();
        Optional<BeanReference<? extends IdentifierBridge>> bridgeReference = this.toBeanReference(IdentifierBridge.class, IdentifierBridgeRef.UndefinedBridgeImplementationType.class, bridgeReferenceAnnotation.type(), bridgeReferenceAnnotation.name());
        Optional<BeanReference<BridgeBuilder<IdentifierBridge<?>>>> bridgeBuilderReference = this.toBeanReference(BridgeBuilder.class, IdentifierBridgeRef.UndefinedBuilderImplementationType.class, bridgeReferenceAnnotation.builderType(), bridgeReferenceAnnotation.builderName());
        if (bridgeReference.isPresent() && bridgeBuilderReference.isPresent()) {
            throw log.invalidDocumentIdDefiningBothBridgeReferenceAndBridgeBuilderReference(annotationHolder.getName());
        }
        if (bridgeReference.isPresent()) {
            BeanBridgeBuilder<? extends IdentifierBridge> rawBuilder;
            BeanBridgeBuilder<? extends IdentifierBridge> castedBuilder = rawBuilder = new BeanBridgeBuilder<IdentifierBridge>(bridgeReference.get());
            return castedBuilder;
        }
        if (bridgeBuilderReference.isPresent()) {
            BeanDelegatingBridgeBuilder<IdentifierBridge> rawBuilder;
            BeanDelegatingBridgeBuilder<IdentifierBridge> castedBuilder = rawBuilder = new BeanDelegatingBridgeBuilder<IdentifierBridge>(bridgeBuilderReference.get(), IdentifierBridge.class);
            return castedBuilder;
        }
        return null;
    }

    <A extends Annotation> BridgeBuilder<? extends RoutingKeyBridge> createRoutingKeyBridgeBuilder(A annotation) {
        RoutingKeyBridgeMapping bridgeMapping = annotation.annotationType().getAnnotation(RoutingKeyBridgeMapping.class);
        RoutingKeyBridgeRef bridgeReferenceAnnotation = bridgeMapping.bridge();
        return this.createAnnotationMappedBridgeBuilder(RoutingKeyBridge.class, RoutingKeyBridgeMapping.class, annotation, this.toBeanReference(RoutingKeyBridge.class, RoutingKeyBridgeRef.UndefinedBridgeImplementationType.class, bridgeReferenceAnnotation.type(), bridgeReferenceAnnotation.name()), this.toBeanReference(AnnotationBridgeBuilder.class, RoutingKeyBridgeRef.UndefinedBuilderImplementationType.class, bridgeReferenceAnnotation.builderType(), bridgeReferenceAnnotation.builderName()));
    }

    <A extends Annotation> BridgeBuilder<? extends TypeBridge> createTypeBridgeBuilder(A annotation) {
        TypeBridgeMapping bridgeMapping = annotation.annotationType().getAnnotation(TypeBridgeMapping.class);
        TypeBridgeRef bridgeReferenceAnnotation = bridgeMapping.bridge();
        return this.createAnnotationMappedBridgeBuilder(TypeBridge.class, TypeBridgeMapping.class, annotation, this.toBeanReference(TypeBridge.class, TypeBridgeRef.UndefinedBridgeImplementationType.class, bridgeReferenceAnnotation.type(), bridgeReferenceAnnotation.name()), this.toBeanReference(AnnotationBridgeBuilder.class, TypeBridgeRef.UndefinedBuilderImplementationType.class, bridgeReferenceAnnotation.builderType(), bridgeReferenceAnnotation.builderName()));
    }

    <A extends Annotation> BridgeBuilder<? extends PropertyBridge> createPropertyBridgeBuilder(A annotation) {
        PropertyBridgeMapping bridgeMapping = annotation.annotationType().getAnnotation(PropertyBridgeMapping.class);
        PropertyBridgeRef bridgeReferenceAnnotation = bridgeMapping.bridge();
        return this.createAnnotationMappedBridgeBuilder(PropertyBridge.class, PropertyBridgeMapping.class, annotation, this.toBeanReference(PropertyBridge.class, PropertyBridgeRef.UndefinedBridgeImplementationType.class, bridgeReferenceAnnotation.type(), bridgeReferenceAnnotation.name()), this.toBeanReference(AnnotationBridgeBuilder.class, PropertyBridgeRef.UndefinedBuilderImplementationType.class, bridgeReferenceAnnotation.builderType(), bridgeReferenceAnnotation.builderName()));
    }

    BridgeBuilder<? extends ValueBridge<?, ?>> createValueBridgeBuilder(ValueBridgeRef bridgeReferenceAnnotation, PojoPropertyModel<?> annotationHolder) {
        Optional<BeanReference<? extends ValueBridge>> bridgeReference = this.toBeanReference(ValueBridge.class, ValueBridgeRef.UndefinedBridgeImplementationType.class, bridgeReferenceAnnotation.type(), bridgeReferenceAnnotation.name());
        Optional<BeanReference<BridgeBuilder<ValueBridge<?, ?>>>> bridgeBuilderReference = this.toBeanReference(BridgeBuilder.class, ValueBridgeRef.UndefinedBuilderImplementationType.class, bridgeReferenceAnnotation.builderType(), bridgeReferenceAnnotation.builderName());
        if (bridgeReference.isPresent() && bridgeBuilderReference.isPresent()) {
            throw log.invalidFieldDefiningBothBridgeReferenceAndBridgeBuilderReference(annotationHolder.getName());
        }
        if (bridgeReference.isPresent()) {
            BeanBridgeBuilder<? extends ValueBridge> rawBuilder;
            BeanBridgeBuilder<? extends ValueBridge> castedBuilder = rawBuilder = new BeanBridgeBuilder<ValueBridge>(bridgeReference.get());
            return castedBuilder;
        }
        if (bridgeBuilderReference.isPresent()) {
            BeanDelegatingBridgeBuilder<ValueBridge> rawBuilder;
            BeanDelegatingBridgeBuilder<ValueBridge> castedBuilder = rawBuilder = new BeanDelegatingBridgeBuilder<ValueBridge>(bridgeBuilderReference.get(), ValueBridge.class);
            return castedBuilder;
        }
        return null;
    }

    private <A extends Annotation, B> BridgeBuilder<? extends B> createAnnotationMappedBridgeBuilder(Class<B> expectedBridgeType, Class<? extends Annotation> bridgeMappingAnnotation, A annotation, Optional<BeanReference<? extends B>> bridgeReferenceOptional, Optional<BeanReference<? extends AnnotationBridgeBuilder>> builderReferenceOptional) {
        if (bridgeReferenceOptional.isPresent() && builderReferenceOptional.isPresent()) {
            throw log.conflictingBridgeReferenceInBridgeMapping(bridgeMappingAnnotation, annotation.annotationType());
        }
        if (bridgeReferenceOptional.isPresent()) {
            return new BeanBridgeBuilder<B>(bridgeReferenceOptional.get());
        }
        if (builderReferenceOptional.isPresent()) {
            return new AnnotationInitializingBeanDelegatingBridgeBuilder<B, A>(builderReferenceOptional.get(), expectedBridgeType, annotation);
        }
        throw log.missingBridgeReferenceInBridgeMapping(bridgeMappingAnnotation, annotation.annotationType());
    }

    private <T> Optional<BeanReference<? extends T>> toBeanReference(Class<T> expectedType, Class<?> undefinedTypeMarker, Class<? extends T> type, String name) {
        Class<? extends T> cleanedUpType;
        String cleanedUpName = name.isEmpty() ? null : name;
        Class<? extends T> clazz = cleanedUpType = undefinedTypeMarker.equals(type) ? null : type;
        if (cleanedUpName == null && cleanedUpType == null) {
            return Optional.empty();
        }
        Class<Object> defaultedType = cleanedUpType == null ? expectedType : cleanedUpType;
        return Optional.of(BeanReference.of(defaultedType, (String)cleanedUpName));
    }
}

