/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.scope.impl.PojoScopeIndexedTypeContextProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContextProvider;
import org.hibernate.search.util.common.impl.Closer;

public class PojoIndexedTypeManagerContainer
implements PojoWorkIndexedTypeContextProvider,
PojoScopeIndexedTypeContextProvider {
    private final Map<Class<?>, PojoIndexedTypeManager<?, ?, ?>> byExactClass;
    private final Map<Class<?>, Set<? extends PojoIndexedTypeManager<?, ?, ?>>> bySuperClass;
    private final Set<PojoIndexedTypeManager<?, ?, ?>> all;

    public static Builder builder() {
        return new Builder();
    }

    private PojoIndexedTypeManagerContainer(Builder builder) {
        this.byExactClass = new HashMap(builder.byExactClass);
        this.bySuperClass = new HashMap(builder.bySuperClass);
        this.bySuperClass.replaceAll((k, v) -> Collections.unmodifiableSet(v));
        this.all = Collections.unmodifiableSet(new LinkedHashSet(this.byExactClass.values()));
    }

    public <E> Optional<PojoIndexedTypeManager<?, E, ?>> getByExactClass(Class<E> clazz) {
        return Optional.ofNullable(this.byExactClass.get(clazz));
    }

    public <E> Optional<Set<PojoIndexedTypeManager<?, ? extends E, ?>>> getAllBySuperClass(Class<E> clazz) {
        return Optional.ofNullable(this.bySuperClass.get(clazz));
    }

    Set<PojoIndexedTypeManager<?, ?, ?>> getAll() {
        return this.all;
    }

    public static class Builder {
        private final Map<Class<?>, PojoIndexedTypeManager<?, ?, ?>> byExactClass = new LinkedHashMap();
        private final Map<Class<?>, Set<PojoIndexedTypeManager<?, ?, ?>>> bySuperClass = new LinkedHashMap();

        private Builder() {
        }

        public <E> void add(PojoRawTypeModel<E> typeModel, PojoIndexedTypeManager<?, E, ?> typeManager) {
            this.byExactClass.put(typeModel.getJavaClass(), typeManager);
            typeModel.getAscendingSuperTypes().map(PojoRawTypeModel::getJavaClass).forEach(clazz -> this.bySuperClass.computeIfAbsent((Class<?>)clazz, ignored -> new LinkedHashSet()).add(typeManager));
        }

        public void closeOnFailure() {
            try (Closer closer = new Closer();){
                closer.pushAll(PojoIndexedTypeManager::close, this.byExactClass.values());
            }
        }

        public PojoIndexedTypeManagerContainer build() {
            return new PojoIndexedTypeManagerContainer(this);
        }
    }
}

