/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.spi;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.engine.mapper.mapping.building.spi.Mapper;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingConfigurationCollector;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingInitiator;
import org.hibernate.search.engine.mapper.mapping.building.spi.TypeMetadataContributorProvider;
import org.hibernate.search.engine.mapper.mapping.spi.MappingBuildContext;
import org.hibernate.search.engine.mapper.mapping.spi.MappingPartialBuildState;
import org.hibernate.search.mapper.pojo.extractor.ContainerExtractorDefinitionContext;
import org.hibernate.search.mapper.pojo.extractor.spi.ContainerExtractorRegistry;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMapper;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMapperDelegate;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.AnnotationMappingDefinitionContext;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl.AnnotationMappingDefinitionContextImpl;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.ProgrammaticMappingDefinitionContext;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl.ProgrammaticMappingDefinitionContextImpl;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingConfigurationContributor;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;

public abstract class AbstractPojoMappingInitiator<MPBS extends MappingPartialBuildState>
implements MappingInitiator<PojoTypeMetadataContributor, MPBS> {
    private final PojoBootstrapIntrospector introspector;
    private boolean implicitProvidedId;
    private boolean multiTenancyEnabled;
    private final AnnotationMappingDefinitionContextImpl annotationMappingDefinition;
    private final ContainerExtractorRegistry.Builder containerExtractorRegistryBuilder;
    private final List<PojoMappingConfigurationContributor> delegates = new ArrayList<PojoMappingConfigurationContributor>();

    protected AbstractPojoMappingInitiator(PojoBootstrapIntrospector introspector) {
        this.introspector = introspector;
        this.annotationMappingDefinition = new AnnotationMappingDefinitionContextImpl(introspector);
        this.addConfigurationContributor(this.annotationMappingDefinition);
        this.containerExtractorRegistryBuilder = ContainerExtractorRegistry.builder();
    }

    public ProgrammaticMappingDefinitionContext programmaticMapping() {
        ProgrammaticMappingDefinitionContextImpl definition = new ProgrammaticMappingDefinitionContextImpl(this.introspector);
        this.addConfigurationContributor(definition);
        return definition;
    }

    public AnnotationMappingDefinitionContext annotationMapping() {
        return this.annotationMappingDefinition;
    }

    public ContainerExtractorDefinitionContext containerExtractors() {
        return this.containerExtractorRegistryBuilder;
    }

    public void setImplicitProvidedId(boolean implicitProvidedId) {
        this.implicitProvidedId = implicitProvidedId;
    }

    public void setMultiTenancyEnabled(boolean multiTenancyEnabled) {
        this.multiTenancyEnabled = multiTenancyEnabled;
    }

    public void setAnnotatedTypeDiscoveryEnabled(boolean annotatedTypeDiscoveryEnabled) {
        this.annotationMappingDefinition.setAnnotatedTypeDiscoveryEnabled(annotatedTypeDiscoveryEnabled);
    }

    public void configure(MappingBuildContext buildContext, MappingConfigurationCollector<PojoTypeMetadataContributor> configurationCollector) {
        if (this.multiTenancyEnabled) {
            configurationCollector.enableMultiTenancy();
        }
        for (PojoMappingConfigurationContributor delegate : this.delegates) {
            delegate.configure(buildContext, configurationCollector);
        }
    }

    public Mapper<MPBS> createMapper(MappingBuildContext buildContext, TypeMetadataContributorProvider<PojoTypeMetadataContributor> contributorProvider) {
        return new PojoMapper<MPBS>(buildContext, contributorProvider, this.introspector, this.containerExtractorRegistryBuilder.build(), this.implicitProvidedId, this.createMapperDelegate());
    }

    protected abstract PojoMapperDelegate<MPBS> createMapperDelegate();

    protected final void addConfigurationContributor(PojoMappingConfigurationContributor contributor) {
        this.delegates.add(contributor);
    }
}

