/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.MarkerBuildContext;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoEntityTypeAdditionalMetadataBuilder;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoPropertyAdditionalMetadataBuilder;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.spi.PojoAdditionalMetadataCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.spi.PojoAdditionalMetadataCollectorTypeNode;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoPropertyAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilterFactory;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.reporting.impl.PojoEventContexts;

class PojoTypeAdditionalMetadataBuilder
implements PojoAdditionalMetadataCollectorTypeNode {
    private final MarkerBuildContext markerBuildContext;
    private final FailureCollector failureCollector;
    private final PojoRawTypeModel<?> rawTypeModel;
    private PojoEntityTypeAdditionalMetadataBuilder entityTypeMetadataBuilder;
    private final Map<String, PojoPropertyAdditionalMetadataBuilder> propertyBuilders = new LinkedHashMap<String, PojoPropertyAdditionalMetadataBuilder>();

    PojoTypeAdditionalMetadataBuilder(MarkerBuildContext markerBuildContext, FailureCollector failureCollector, PojoRawTypeModel<?> rawTypeModel) {
        this.markerBuildContext = markerBuildContext;
        this.failureCollector = failureCollector;
        this.rawTypeModel = rawTypeModel;
    }

    @Override
    public ContextualFailureCollector getFailureCollector() {
        return this.failureCollector.withContext(PojoEventContexts.fromType(this.rawTypeModel));
    }

    @Override
    public PojoEntityTypeAdditionalMetadataBuilder markAsEntity(PojoPathFilterFactory<Set<String>> pathFilterFactory) {
        this.entityTypeMetadataBuilder = new PojoEntityTypeAdditionalMetadataBuilder(this, pathFilterFactory);
        return this.entityTypeMetadataBuilder;
    }

    @Override
    public PojoAdditionalMetadataCollectorPropertyNode property(String propertyName) {
        return this.propertyBuilders.computeIfAbsent(propertyName, ignored -> new PojoPropertyAdditionalMetadataBuilder(this, propertyName));
    }

    MarkerBuildContext getMarkerBuildContext() {
        return this.markerBuildContext;
    }

    public PojoTypeAdditionalMetadata build() {
        HashMap<String, PojoPropertyAdditionalMetadata> properties = new HashMap<String, PojoPropertyAdditionalMetadata>();
        for (Map.Entry<String, PojoPropertyAdditionalMetadataBuilder> entry : this.propertyBuilders.entrySet()) {
            properties.put(entry.getKey(), entry.getValue().build());
        }
        return new PojoTypeAdditionalMetadata(this.entityTypeMetadataBuilder == null ? Optional.empty() : Optional.of(this.entityTypeMetadataBuilder.build()), properties);
    }
}

