/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.engine.mapper.mapping.building.spi.TypeMetadataContributorProvider;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.MarkerBuildContext;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoTypeAdditionalMetadataBuilder;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoValueAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;

public class PojoTypeAdditionalMetadataProvider {
    private final MarkerBuildContext markerBuildContext;
    private final FailureCollector failureCollector;
    private final TypeMetadataContributorProvider<PojoTypeMetadataContributor> modelContributorProvider;
    private final Map<PojoRawTypeModel<?>, PojoTypeAdditionalMetadata> cache = new HashMap();

    public PojoTypeAdditionalMetadataProvider(MarkerBuildContext markerBuildContext, FailureCollector failureCollector, TypeMetadataContributorProvider<PojoTypeMetadataContributor> modelContributorProvider) {
        this.markerBuildContext = markerBuildContext;
        this.failureCollector = failureCollector;
        this.modelContributorProvider = modelContributorProvider;
    }

    public PojoTypeAdditionalMetadata get(PojoRawTypeModel<?> typeModel) {
        return this.cache.computeIfAbsent(typeModel, this::createTypeAdditionalMetadata);
    }

    public PojoValueAdditionalMetadata get(BoundPojoModelPathValueNode<?, ?, ?> valueNode) {
        BoundPojoModelPath propertyNode = valueNode.getParent();
        BoundPojoModelPath typeNode = ((BoundPojoModelPathPropertyNode)propertyNode).getParent();
        PojoTypeModel typeModel = ((BoundPojoModelPathTypeNode)typeNode).getTypeModel();
        return this.get(typeModel.getRawType()).getPropertyAdditionalMetadata(((BoundPojoModelPathPropertyNode)propertyNode).getPropertyModel().getName()).getValueAdditionalMetadata(valueNode.getExtractorPath());
    }

    private PojoTypeAdditionalMetadata createTypeAdditionalMetadata(PojoRawTypeModel<?> typeModel) {
        PojoTypeAdditionalMetadataBuilder builder = new PojoTypeAdditionalMetadataBuilder(this.markerBuildContext, this.failureCollector, typeModel);
        this.modelContributorProvider.forEach(typeModel, c -> c.contributeAdditionalMetadata(builder));
        return builder.build();
    }
}

