/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.dependency.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoIndexingDependencyCollectorNode;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoIndexingDependencyCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoIndexingDependencyCollectorTypeNode;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoIndexingDependencyCollectorValueNode;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorBinder;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoTypeAdditionalMetadataProvider;
import org.hibernate.search.mapper.pojo.model.dependency.PojoOtherEntityDependencyContext;
import org.hibernate.search.mapper.pojo.model.dependency.PojoPropertyDependencyContext;
import org.hibernate.search.mapper.pojo.model.dependency.impl.AbstractPojoBridgedElementDependencyContext;
import org.hibernate.search.mapper.pojo.model.dependency.impl.PojoOtherEntityDependencyContextImpl;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.binding.impl.PojoModelPathBinder;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathOriginalTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;

public class PojoPropertyDependencyContextImpl<P>
extends AbstractPojoBridgedElementDependencyContext
implements PojoPropertyDependencyContext {
    private final BoundPojoModelPathPropertyNode<?, P> modelPath;
    private final Map<ContainerExtractorPath, ValueDependencyContext> valueDependencyContexts = new LinkedHashMap<ContainerExtractorPath, ValueDependencyContext>();

    public PojoPropertyDependencyContextImpl(PojoBootstrapIntrospector introspector, ContainerExtractorBinder containerExtractorBinder, PojoTypeAdditionalMetadataProvider typeAdditionalMetadataProvider, BoundPojoModelPathPropertyNode<?, P> modelPath) {
        super(introspector, containerExtractorBinder, typeAdditionalMetadataProvider);
        this.modelPath = modelPath;
    }

    @Override
    public PojoPropertyDependencyContext use(ContainerExtractorPath extractorPathFromBridgedProperty, PojoModelPathValueNode pathFromExtractedBridgedPropertyValueToUsedValue) {
        this.valueDependencyContexts.computeIfAbsent(extractorPathFromBridgedProperty, x$0 -> new ValueDependencyContext((ContainerExtractorPath)x$0)).use(pathFromExtractedBridgedPropertyValueToUsedValue);
        return this;
    }

    @Override
    public PojoOtherEntityDependencyContext fromOtherEntity(ContainerExtractorPath extractorPathFromBridgedProperty, Class<?> otherEntityType, PojoModelPathValueNode pathFromOtherEntityTypeToBridgedPropertyExtractedType) {
        return this.valueDependencyContexts.computeIfAbsent(extractorPathFromBridgedProperty, x$0 -> new ValueDependencyContext((ContainerExtractorPath)x$0)).addOtherEntityDependencyContext(otherEntityType, pathFromOtherEntityTypeToBridgedPropertyExtractedType);
    }

    @Override
    public void useRootOnly() {
        super.useRootOnly();
        ContainerExtractorPath noExtractorPath = ContainerExtractorPath.noExtractors();
        this.valueDependencyContexts.put(noExtractorPath, new ValueDependencyContext(noExtractorPath));
    }

    @Override
    public boolean hasNonRootDependency() {
        if (this.valueDependencyContexts.isEmpty()) {
            return false;
        }
        if (this.valueDependencyContexts.size() > 1) {
            return true;
        }
        ValueDependencyContext noExtractorValue = this.valueDependencyContexts.get(ContainerExtractorPath.noExtractors());
        return noExtractorValue == null || noExtractorValue.hasExplicitDependency();
    }

    public void contributeDependencies(PojoIndexingDependencyCollectorPropertyNode<?, P> dependencyCollector) {
        for (Map.Entry<ContainerExtractorPath, ValueDependencyContext> entry : this.valueDependencyContexts.entrySet()) {
            ContainerExtractorPath extractorPathFromBridgedElement = entry.getKey();
            PojoIndexingDependencyCollectorValueNode<P, ?> dependencyCollectorValueNode = dependencyCollector.value(extractorPathFromBridgedElement);
            dependencyCollectorValueNode.collectDependency();
            entry.getValue().contributeDependencies(dependencyCollectorValueNode);
        }
    }

    private class ValueDependencyContext {
        private final BoundPojoModelPathOriginalTypeNode<?> valueTypePath;
        private final List<PojoModelPathValueNode> usedPaths = new ArrayList<PojoModelPathValueNode>();
        private final List<PojoOtherEntityDependencyContextImpl<?>> otherEntityDependencyContexts = new ArrayList();

        private ValueDependencyContext(ContainerExtractorPath extractorPathFromBridgedProperty) {
            BoundPojoModelPathValueNode<?, ?, ?> valuePath = PojoPropertyDependencyContextImpl.this.bindingPathWalker.value(PojoPropertyDependencyContextImpl.this.modelPath, extractorPathFromBridgedProperty);
            this.valueTypePath = valuePath.type();
        }

        public void contributeDependencies(PojoIndexingDependencyCollectorValueNode<?, ?> dependencyCollectorValueNode) {
            PojoIndexingDependencyCollectorTypeNode<?> dependencyCollectorTypeNode = dependencyCollectorValueNode.type();
            for (PojoModelPathValueNode pojoModelPathValueNode : this.usedPaths) {
                PojoModelPathBinder.bind(dependencyCollectorTypeNode, pojoModelPathValueNode, PojoIndexingDependencyCollectorNode.walker());
            }
            for (PojoOtherEntityDependencyContextImpl pojoOtherEntityDependencyContextImpl : this.otherEntityDependencyContexts) {
                pojoOtherEntityDependencyContextImpl.contributeDependencies(dependencyCollectorTypeNode);
            }
        }

        private PojoOtherEntityDependencyContextImpl<?> addOtherEntityDependencyContext(Class<?> otherEntityType, PojoModelPathValueNode pathFromOtherEntityTypeToBridgedPropertyExtractedType) {
            PojoOtherEntityDependencyContextImpl<?> otherContext = PojoPropertyDependencyContextImpl.this.createOtherEntityDependencyContext(this.valueTypePath.getTypeModel().getRawType(), otherEntityType, pathFromOtherEntityTypeToBridgedPropertyExtractedType);
            this.otherEntityDependencyContexts.add(otherContext);
            return otherContext;
        }

        public void use(PojoModelPathValueNode pathFromExtractedBridgedPropertyValueToUsedValue) {
            PojoModelPathBinder.bind(this.valueTypePath, pathFromExtractedBridgedPropertyValueToUsedValue, PojoPropertyDependencyContextImpl.this.bindingPathWalker);
            this.usedPaths.add(pathFromExtractedBridgedPropertyValueToUsedValue);
        }

        public boolean hasExplicitDependency() {
            return !this.usedPaths.isEmpty() || !this.otherEntityDependencyContexts.isEmpty();
        }
    }
}

