/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.engine.backend.document.model.dsl.ObjectFieldStorage;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexBindingContext;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.BridgeBuilder;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoIndexingDependencyCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoIndexingDependencyCollectorValueNode;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.building.impl.BoundValueBridge;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.mapping.building.spi.FieldModelContributor;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMappingCollectorValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathOriginalTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.processing.building.impl.AbstractPojoProcessorNodeBuilder;
import org.hibernate.search.mapper.pojo.processing.building.impl.PojoIndexingProcessorTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessorValueBridgeNode;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class PojoIndexingProcessorValueNodeBuilderDelegate<P, V>
extends AbstractPojoProcessorNodeBuilder
implements PojoMappingCollectorValueNode {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final BoundPojoModelPathValueNode<?, P, V> modelPath;
    private final Collection<BoundValueBridge<V, ?>> boundBridges = new ArrayList();
    private final Collection<PojoIndexingProcessorTypeNodeBuilder<V>> typeNodeBuilders = new ArrayList<PojoIndexingProcessorTypeNodeBuilder<V>>();
    private final boolean multiValuedFromContainerExtractor;

    PojoIndexingProcessorValueNodeBuilderDelegate(BoundPojoModelPathValueNode<?, P, V> modelPath, PojoMappingHelper mappingHelper, IndexBindingContext bindingContext, boolean multiValuedFromContainerExtractor) {
        super(mappingHelper, bindingContext);
        this.modelPath = modelPath;
        this.multiValuedFromContainerExtractor = multiValuedFromContainerExtractor;
    }

    @Override
    public void valueBridge(BridgeBuilder<? extends ValueBridge<?, ?>> builder, String relativeFieldName, FieldModelContributor fieldModelContributor) {
        String defaultedRelativeFieldName = relativeFieldName;
        if (defaultedRelativeFieldName == null) {
            defaultedRelativeFieldName = ((BoundPojoModelPathPropertyNode)this.modelPath.getParent()).getPropertyModel().getName();
        }
        this.mappingHelper.getIndexModelBinder().addValueBridge(this.bindingContext, this.modelPath, this.multiValuedFromContainerExtractor, builder, defaultedRelativeFieldName, fieldModelContributor).ifPresent(this.boundBridges::add);
    }

    @Override
    public void indexedEmbedded(String relativePrefix, ObjectFieldStorage storage, Integer maxDepth, Set<String> includePaths) {
        String defaultedRelativePrefix = relativePrefix;
        if (defaultedRelativePrefix == null) {
            defaultedRelativePrefix = ((BoundPojoModelPathPropertyNode)this.modelPath.getParent()).getPropertyModel().getName() + ".";
        }
        BoundPojoModelPath holderTypePath = ((BoundPojoModelPathPropertyNode)this.modelPath.getParent()).getParent();
        Optional nestedBindingContextOptional = this.bindingContext.addIndexedEmbeddedIfIncluded(((BoundPojoModelPathTypeNode)holderTypePath).getTypeModel().getRawType(), this.multiValuedFromContainerExtractor, defaultedRelativePrefix, storage, maxDepth, includePaths);
        nestedBindingContextOptional.ifPresent(nestedBindingContext -> {
            BoundPojoModelPathOriginalTypeNode<V> embeddedTypeModelPath = this.modelPath.type();
            PojoIndexingProcessorTypeNodeBuilder nestedProcessorBuilder = new PojoIndexingProcessorTypeNodeBuilder(embeddedTypeModelPath, this.mappingHelper, (IndexBindingContext)nestedBindingContext, Optional.empty(), nestedBindingContext.getParentIndexObjectReferences());
            this.typeNodeBuilders.add(nestedProcessorBuilder);
            this.mappingHelper.getContributorProvider().forEach(((BoundPojoModelPathTypeNode)embeddedTypeModelPath).getTypeModel().getRawType(), c -> c.contributeMapping(nestedProcessorBuilder));
            Set uselessIncludePaths = nestedBindingContext.getUselessIncludePaths();
            if (!uselessIncludePaths.isEmpty()) {
                Set encounteredFieldPaths = nestedBindingContext.getEncounteredFieldPaths();
                throw log.uselessIncludePathFilters(uselessIncludePaths, encounteredFieldPaths);
            }
        });
    }

    @Override
    BoundPojoModelPathValueNode<?, P, V> getModelPath() {
        return this.modelPath;
    }

    @Override
    void closeOnFailure() {
        try (Closer closer = new Closer();){
            closer.pushAll(boundBridge -> ((ValueBridge)boundBridge.getBridgeHolder().get()).close(), this.boundBridges);
            closer.pushAll(boundBridge -> boundBridge.getBridgeHolder().close(), this.boundBridges);
            closer.pushAll(PojoIndexingProcessorTypeNodeBuilder::closeOnFailure, this.typeNodeBuilders);
        }
    }

    Collection<PojoIndexingProcessor<? super V>> build(PojoIndexingDependencyCollectorPropertyNode<?, P> parentDependencyCollector) {
        try {
            return this.doBuild(parentDependencyCollector);
        }
        catch (RuntimeException e) {
            this.getFailureCollector().add((Throwable)e);
            return Collections.emptyList();
        }
    }

    private Collection<PojoIndexingProcessor<? super V>> doBuild(PojoIndexingDependencyCollectorPropertyNode<?, P> parentDependencyCollector) {
        PojoIndexingDependencyCollectorValueNode valueDependencyCollector = parentDependencyCollector.value(this.modelPath.getBoundExtractorPath());
        List<Object> immutableNestedNodes = this.boundBridges.isEmpty() && this.typeNodeBuilders.isEmpty() ? Collections.emptyList() : new ArrayList(this.boundBridges.size() + this.typeNodeBuilders.size());
        try {
            for (BoundValueBridge<V, ?> boundBridge : this.boundBridges) {
                immutableNestedNodes.add(PojoIndexingProcessorValueNodeBuilderDelegate.createValueBridgeNode(boundBridge));
            }
            this.typeNodeBuilders.stream().map(builder -> builder.build(valueDependencyCollector.type())).filter(Optional::isPresent).map(Optional::get).forEach(immutableNestedNodes::add);
            if (!immutableNestedNodes.isEmpty()) {
                valueDependencyCollector.collectDependency();
            }
            return immutableNestedNodes;
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).pushAll(PojoIndexingProcessor::close, immutableNestedNodes);
            throw e;
        }
    }

    private static <V, F> PojoIndexingProcessor<V> createValueBridgeNode(BoundValueBridge<V, F> boundBridge) {
        return new PojoIndexingProcessorValueBridgeNode<V, F>(boundBridge.getBridgeHolder(), boundBridge.getIndexFieldReference());
    }
}

