/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.scope.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.search.engine.mapper.scope.spi.MappedIndexScope;
import org.hibernate.search.engine.mapper.scope.spi.MappedIndexScopeBuilder;
import org.hibernate.search.engine.mapper.session.context.spi.DetachedSessionContextImplementor;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateFactoryContext;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactoryContext;
import org.hibernate.search.engine.search.dsl.query.SearchQueryResultDefinitionContext;
import org.hibernate.search.engine.search.dsl.sort.SearchSortFactoryContext;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.context.spi.AbstractPojoMappingContextImplementor;
import org.hibernate.search.mapper.pojo.scope.impl.PojoScopeContainedTypeContextProvider;
import org.hibernate.search.mapper.pojo.scope.impl.PojoScopeIndexedTypeContext;
import org.hibernate.search.mapper.pojo.scope.impl.PojoScopeIndexedTypeContextProvider;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeDelegate;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeTypeExtendedContextProvider;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;
import org.hibernate.search.mapper.pojo.work.impl.PojoScopeWorkExecutorImpl;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoScopeWorkExecutor;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class PojoScopeDelegateImpl<R, E, E2, C>
implements PojoScopeDelegate<R, E2, C> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Set<? extends PojoScopeIndexedTypeContext<?, ? extends E, ?>> targetedTypeContexts;
    private final Set<C> targetedTypeExtendedContexts;
    private final AbstractPojoSessionContextImplementor sessionContext;
    private MappedIndexScope<R, E2> delegate;
    private PojoScopeWorkExecutor executor;

    public static <R, E, E2, C> PojoScopeDelegate<R, E2, C> create(PojoScopeIndexedTypeContextProvider indexedTypeContextProvider, PojoScopeContainedTypeContextProvider containedTypeContextProvider, Collection<? extends Class<? extends E>> targetedTypes, PojoScopeTypeExtendedContextProvider<E, C> indexedTypeExtendedContextProvider, AbstractPojoSessionContextImplementor sessionContext) {
        if (targetedTypes.isEmpty()) {
            throw log.invalidEmptyTargetForScope();
        }
        LinkedHashSet targetedTypeContexts = new LinkedHashSet();
        LinkedHashSet nonIndexedTypes = new LinkedHashSet();
        LinkedHashSet nonIndexedButContainedTypes = new LinkedHashSet();
        for (Class<E> clazz : targetedTypes) {
            Optional<Set<PojoScopeIndexedTypeContext<?, E, ?>>> targetedTypeManagersForType = indexedTypeContextProvider.getAllBySuperClass(clazz);
            if (targetedTypeManagersForType.isPresent()) {
                targetedTypeContexts.addAll(targetedTypeManagersForType.get());
                continue;
            }
            nonIndexedTypes.add(clazz);
            if (!containedTypeContextProvider.getByExactClass(clazz).isPresent()) continue;
            nonIndexedButContainedTypes.add(clazz);
        }
        if (!nonIndexedTypes.isEmpty() || !nonIndexedButContainedTypes.isEmpty()) {
            throw log.invalidScopeTarget(nonIndexedTypes, nonIndexedButContainedTypes);
        }
        Set targetedTypeExtendedContexts = targetedTypeContexts.stream().map(PojoWorkIndexedTypeContext::getJavaClass).map(indexedTypeExtendedContextProvider::getByExactClass).collect(Collectors.toCollection(LinkedHashSet::new));
        return new PojoScopeDelegateImpl<R, E, E2, C>(targetedTypeContexts, targetedTypeExtendedContexts, sessionContext);
    }

    private PojoScopeDelegateImpl(Set<? extends PojoScopeIndexedTypeContext<?, ? extends E, ?>> targetedTypeContexts, Set<C> targetedTypeExtendedContexts, AbstractPojoSessionContextImplementor sessionContext) {
        this.targetedTypeContexts = targetedTypeContexts;
        this.targetedTypeExtendedContexts = targetedTypeExtendedContexts;
        this.sessionContext = sessionContext;
    }

    @Override
    public Set<C> getIncludedIndexedTypes() {
        return this.targetedTypeExtendedContexts;
    }

    @Override
    public SearchQueryResultDefinitionContext<?, R, E2, SearchProjectionFactoryContext<R, E2>, ?> search(LoadingContextBuilder<R, E2> loadingContextBuilder) {
        return this.getIndexScope().search((SessionContextImplementor)this.sessionContext, loadingContextBuilder);
    }

    @Override
    public SearchPredicateFactoryContext predicate() {
        return this.getIndexScope().predicate();
    }

    @Override
    public SearchSortFactoryContext sort() {
        return this.getIndexScope().sort();
    }

    @Override
    public SearchProjectionFactoryContext<R, E2> projection() {
        return this.getIndexScope().projection();
    }

    @Override
    public PojoScopeWorkExecutor executor() {
        if (this.executor == null) {
            this.executor = new PojoScopeWorkExecutorImpl(this.targetedTypeContexts, DetachedSessionContextImplementor.of((SessionContextImplementor)this.sessionContext));
        }
        return this.executor;
    }

    private MappedIndexScope<R, E2> getIndexScope() {
        AbstractPojoMappingContextImplementor mappingContext = this.sessionContext.getMappingContext();
        if (this.delegate == null) {
            Iterator<PojoScopeIndexedTypeContext<?, E, ?>> iterator = this.targetedTypeContexts.iterator();
            MappedIndexScopeBuilder builder = iterator.next().createScopeBuilder(mappingContext);
            while (iterator.hasNext()) {
                iterator.next().addTo(builder);
            }
            this.delegate = builder.build();
        }
        return this.delegate;
    }
}

