/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkPlan;
import org.hibernate.search.mapper.pojo.dirtiness.impl.PojoReindexingCollector;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;
import org.hibernate.search.mapper.pojo.work.impl.AbstractPojoTypeWorkPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;

public class PojoIndexedTypeWorkPlan<I, E, D extends DocumentElement>
extends AbstractPojoTypeWorkPlan {
    private final PojoWorkIndexedTypeContext<I, E, D> typeContext;
    private final IndexWorkPlan<D> delegate;
    private final Map<I, IndexedEntityWorkPlan> workPlansPerId = new LinkedHashMap<I, IndexedEntityWorkPlan>();

    public PojoIndexedTypeWorkPlan(PojoWorkIndexedTypeContext<I, E, D> typeContext, AbstractPojoSessionContextImplementor sessionContext, IndexWorkPlan<D> delegate) {
        super(sessionContext);
        this.typeContext = typeContext;
        this.delegate = delegate;
    }

    @Override
    void add(Object providedId, Object entity) {
        Supplier<E> entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        I identifier = this.typeContext.getIdentifierMapping().getIdentifier(providedId, entitySupplier);
        this.getWork(identifier).add(entitySupplier);
    }

    @Override
    void update(Object providedId, Object entity) {
        Supplier<E> entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        I identifier = this.typeContext.getIdentifierMapping().getIdentifier(providedId, entitySupplier);
        this.getWork(identifier).update(entitySupplier);
    }

    @Override
    void update(Object providedId, Object entity, String ... dirtyPaths) {
        Supplier<E> entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        I identifier = this.typeContext.getIdentifierMapping().getIdentifier(providedId, entitySupplier);
        this.getWork(identifier).update(entitySupplier, dirtyPaths);
    }

    @Override
    void delete(Object providedId, Object entity) {
        Supplier<E> entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        I identifier = this.typeContext.getIdentifierMapping().getIdentifier(providedId, entitySupplier);
        this.getWork(identifier).delete(entitySupplier);
    }

    @Override
    void purge(Object providedId) {
        I identifier = this.typeContext.getIdentifierMapping().getIdentifier(providedId);
        this.getWork(identifier).purge();
    }

    void updateBecauseOfContained(Object entity) {
        Supplier<E> entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        I identifier = this.typeContext.getIdentifierMapping().getIdentifier(null, entitySupplier);
        if (!this.workPlansPerId.containsKey(identifier)) {
            this.getWork(identifier).updateBecauseOfContained(entitySupplier);
        }
    }

    void resolveDirty(PojoReindexingCollector containingEntityCollector) {
        for (IndexedEntityWorkPlan workPerDocument : this.workPlansPerId.values()) {
            workPerDocument.resolveDirty(containingEntityCollector);
        }
    }

    void prepare() {
        this.sendWorksToDelegate();
        this.getDelegate().prepare();
    }

    CompletableFuture<?> execute() {
        this.sendWorksToDelegate();
        return this.delegate.execute();
    }

    private IndexedEntityWorkPlan getWork(I identifier) {
        IndexedEntityWorkPlan work = this.workPlansPerId.get(identifier);
        if (work == null) {
            work = new IndexedEntityWorkPlan(identifier);
            this.workPlansPerId.put(identifier, work);
        }
        return work;
    }

    private IndexWorkPlan<D> getDelegate() {
        return this.delegate;
    }

    private void sendWorksToDelegate() {
        try {
            this.workPlansPerId.values().forEach(IndexedEntityWorkPlan::sendWorkToDelegate);
        }
        finally {
            this.workPlansPerId.clear();
        }
    }

    private class IndexedEntityWorkPlan {
        private final I identifier;
        private Supplier<E> entitySupplier;
        private boolean delete;
        private boolean add;
        private boolean shouldResolveToReindex;
        private boolean considerAllDirty;
        private boolean updatedBecauseOfContained;
        private Set<String> dirtyPaths;

        private IndexedEntityWorkPlan(I identifier) {
            this.identifier = identifier;
        }

        void add(Supplier<E> entitySupplier) {
            this.entitySupplier = entitySupplier;
            this.shouldResolveToReindex = true;
            this.add = true;
        }

        void update(Supplier<E> entitySupplier) {
            this.doUpdate(entitySupplier);
            this.shouldResolveToReindex = true;
            this.considerAllDirty = true;
            this.dirtyPaths = null;
        }

        void update(Supplier<E> entitySupplier, String ... dirtyPaths) {
            this.doUpdate(entitySupplier);
            this.shouldResolveToReindex = true;
            if (!this.considerAllDirty) {
                for (String dirtyPropertyName : dirtyPaths) {
                    this.addDirtyPath(dirtyPropertyName);
                }
            }
        }

        void updateBecauseOfContained(Supplier<E> entitySupplier) {
            this.doUpdate(entitySupplier);
            this.updatedBecauseOfContained = true;
        }

        void delete(Supplier<E> entitySupplier) {
            this.entitySupplier = entitySupplier;
            if (this.add && !this.delete) {
                this.shouldResolveToReindex = false;
                this.considerAllDirty = false;
                this.updatedBecauseOfContained = false;
                this.dirtyPaths = null;
                this.add = false;
                this.delete = false;
            } else {
                this.add = false;
                this.delete = true;
            }
        }

        void purge() {
            this.entitySupplier = null;
            this.shouldResolveToReindex = false;
            this.considerAllDirty = false;
            this.dirtyPaths = null;
            this.add = false;
            this.delete = true;
        }

        void resolveDirty(PojoReindexingCollector containingEntityCollector) {
            if (this.shouldResolveToReindex) {
                this.shouldResolveToReindex = false;
                PojoIndexedTypeWorkPlan.this.typeContext.resolveEntitiesToReindex(containingEntityCollector, PojoIndexedTypeWorkPlan.this.sessionContext.getRuntimeIntrospector(), this.entitySupplier, this.considerAllDirty ? null : this.dirtyPaths);
            }
        }

        void sendWorkToDelegate() {
            DocumentReferenceProvider referenceProvider = PojoIndexedTypeWorkPlan.this.typeContext.toDocumentReferenceProvider(PojoIndexedTypeWorkPlan.this.sessionContext, this.identifier, this.entitySupplier);
            if (this.add) {
                if (this.delete) {
                    if (this.considerAllDirty || this.updatedBecauseOfContained || PojoIndexedTypeWorkPlan.this.typeContext.requiresSelfReindexing(this.dirtyPaths)) {
                        PojoIndexedTypeWorkPlan.this.delegate.update(referenceProvider, PojoIndexedTypeWorkPlan.this.typeContext.toDocumentContributor(this.entitySupplier, PojoIndexedTypeWorkPlan.this.sessionContext));
                    }
                } else {
                    PojoIndexedTypeWorkPlan.this.delegate.add(referenceProvider, PojoIndexedTypeWorkPlan.this.typeContext.toDocumentContributor(this.entitySupplier, PojoIndexedTypeWorkPlan.this.sessionContext));
                }
            } else if (this.delete) {
                PojoIndexedTypeWorkPlan.this.delegate.delete(referenceProvider);
            }
        }

        private void doUpdate(Supplier<E> entitySupplier) {
            this.entitySupplier = entitySupplier;
            if (!this.add) {
                this.delete = true;
                this.add = true;
            }
        }

        private void addDirtyPath(String dirtyPath) {
            if (this.dirtyPaths == null) {
                this.dirtyPaths = new HashSet<String>();
            }
            this.dirtyPaths.add(dirtyPath);
        }
    }
}

