/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.work.execution.spi.IndexDocumentWorkExecutor;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;

public class PojoTypeDocumentWorkExecutor<I, E, D extends DocumentElement> {
    private final AbstractPojoSessionContextImplementor sessionContext;
    private final PojoWorkIndexedTypeContext<I, E, D> typeContext;
    private final IndexDocumentWorkExecutor<D> delegate;

    public PojoTypeDocumentWorkExecutor(PojoWorkIndexedTypeContext<I, E, D> typeContext, AbstractPojoSessionContextImplementor sessionContext, IndexDocumentWorkExecutor<D> delegate) {
        this.sessionContext = sessionContext;
        this.typeContext = typeContext;
        this.delegate = delegate;
    }

    CompletableFuture<?> add(Object providedId, Object entity) {
        Supplier<E> entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        I identifier = this.typeContext.getIdentifierMapping().getIdentifier(providedId, entitySupplier);
        DocumentReferenceProvider referenceProvider = this.typeContext.toDocumentReferenceProvider(this.sessionContext, identifier, entitySupplier);
        return this.delegate.add(referenceProvider, this.typeContext.toDocumentContributor(entitySupplier, this.sessionContext));
    }
}

