/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;
import org.hibernate.search.mapper.pojo.work.impl.AbstractPojoTypeWorkPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoContainedTypeWorkPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoIndexedTypeWorkPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkContainedTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkContainedTypeContextProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContextProvider;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkPlan;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoWorkPlanImpl
implements PojoWorkPlan {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoWorkIndexedTypeContextProvider indexedTypeContextProvider;
    private final PojoWorkContainedTypeContextProvider containedTypeContextProvider;
    private final AbstractPojoSessionContextImplementor sessionContext;
    private final PojoRuntimeIntrospector introspector;
    private final DocumentCommitStrategy commitStrategy;
    private final DocumentRefreshStrategy refreshStrategy;
    private final Map<Class<?>, PojoIndexedTypeWorkPlan<?, ?, ?>> indexedTypeDelegates = new LinkedHashMap();
    private final Map<Class<?>, PojoContainedTypeWorkPlan<?>> containedTypeDelegates = new HashMap();

    public PojoWorkPlanImpl(PojoWorkIndexedTypeContextProvider indexedTypeContextProvider, PojoWorkContainedTypeContextProvider containedTypeContextProvider, AbstractPojoSessionContextImplementor sessionContext, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        this.indexedTypeContextProvider = indexedTypeContextProvider;
        this.containedTypeContextProvider = containedTypeContextProvider;
        this.sessionContext = sessionContext;
        this.introspector = sessionContext.getRuntimeIntrospector();
        this.commitStrategy = commitStrategy;
        this.refreshStrategy = refreshStrategy;
    }

    @Override
    public void add(Object entity) {
        this.add(null, entity);
    }

    @Override
    public void add(Object providedId, Object entity) {
        Class<Object> clazz = this.introspector.getClass(entity);
        AbstractPojoTypeWorkPlan delegate = this.getDelegate(clazz);
        delegate.add(providedId, entity);
    }

    @Override
    public void update(Object entity) {
        this.update(null, entity);
    }

    @Override
    public void update(Object providedId, Object entity) {
        Class<Object> clazz = this.introspector.getClass(entity);
        AbstractPojoTypeWorkPlan delegate = this.getDelegate(clazz);
        delegate.update(providedId, entity);
    }

    @Override
    public void update(Object entity, String ... dirtyPaths) {
        this.update(null, entity, dirtyPaths);
    }

    @Override
    public void update(Object providedId, Object entity, String ... dirtyPaths) {
        Class<Object> clazz = this.getIntrospector().getClass(entity);
        AbstractPojoTypeWorkPlan delegate = this.getDelegate(clazz);
        delegate.update(providedId, entity, dirtyPaths);
    }

    @Override
    public void delete(Object entity) {
        this.delete(null, entity);
    }

    @Override
    public void delete(Object providedId, Object entity) {
        Class<Object> clazz = this.introspector.getClass(entity);
        AbstractPojoTypeWorkPlan delegate = this.getDelegate(clazz);
        delegate.delete(providedId, entity);
    }

    @Override
    public void purge(Class<?> clazz, Object providedId) {
        AbstractPojoTypeWorkPlan delegate = this.getDelegate(clazz);
        delegate.purge(providedId);
    }

    @Override
    public void prepare() {
        for (PojoContainedTypeWorkPlan<?> pojoContainedTypeWorkPlan : this.containedTypeDelegates.values()) {
            pojoContainedTypeWorkPlan.resolveDirty(this::updateBecauseOfContained);
        }
        for (PojoIndexedTypeWorkPlan pojoIndexedTypeWorkPlan : this.indexedTypeDelegates.values()) {
            pojoIndexedTypeWorkPlan.resolveDirty(this::updateBecauseOfContained);
        }
        for (PojoIndexedTypeWorkPlan pojoIndexedTypeWorkPlan : this.indexedTypeDelegates.values()) {
            pojoIndexedTypeWorkPlan.prepare();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<?> execute() {
        try {
            this.prepare();
            ArrayList futures = new ArrayList();
            for (PojoIndexedTypeWorkPlan<?, ?, ?> delegate : this.indexedTypeDelegates.values()) {
                futures.add(delegate.execute());
            }
            CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            return completableFuture;
        }
        finally {
            this.indexedTypeDelegates.clear();
        }
    }

    private PojoRuntimeIntrospector getIntrospector() {
        return this.introspector;
    }

    private AbstractPojoTypeWorkPlan getDelegate(Class<?> clazz) {
        AbstractPojoTypeWorkPlan delegate = this.indexedTypeDelegates.get(clazz);
        if (delegate == null && (delegate = (AbstractPojoTypeWorkPlan)this.containedTypeDelegates.get(clazz)) == null) {
            delegate = this.createDelegate(clazz);
        }
        return delegate;
    }

    private AbstractPojoTypeWorkPlan createDelegate(Class<?> clazz) {
        Optional<PojoWorkIndexedTypeContext<?, ?, ?>> indexedTypeContextOptional = this.indexedTypeContextProvider.getByExactClass(clazz);
        if (indexedTypeContextOptional.isPresent()) {
            PojoIndexedTypeWorkPlan<?, ?, ?> delegate = indexedTypeContextOptional.get().createWorkPlan(this.sessionContext, this.commitStrategy, this.refreshStrategy);
            this.indexedTypeDelegates.put(clazz, delegate);
            return delegate;
        }
        Optional<PojoWorkContainedTypeContext<?>> containedTypeContextOptional = this.containedTypeContextProvider.getByExactClass(clazz);
        if (containedTypeContextOptional.isPresent()) {
            PojoContainedTypeWorkPlan<?> delegate = containedTypeContextOptional.get().createWorkPlan(this.sessionContext);
            this.containedTypeDelegates.put(clazz, delegate);
            return delegate;
        }
        throw log.notIndexedTypeNorAsDelegate(clazz);
    }

    private PojoIndexedTypeWorkPlan<?, ?, ?> getOrCreateIndexedDelegateForContainedUpdate(Class<?> clazz) {
        PojoIndexedTypeWorkPlan<?, ?, ?> delegate = this.indexedTypeDelegates.get(clazz);
        if (delegate != null) {
            return delegate;
        }
        Optional<PojoWorkIndexedTypeContext<?, ?, ?>> indexedTypeManagerOptional = this.indexedTypeContextProvider.getByExactClass(clazz);
        if (indexedTypeManagerOptional.isPresent()) {
            delegate = indexedTypeManagerOptional.get().createWorkPlan(this.sessionContext, this.commitStrategy, this.refreshStrategy);
            this.indexedTypeDelegates.put(clazz, delegate);
            return delegate;
        }
        throw new AssertionFailure("Attempt to reindex an entity of type " + clazz + " because a contained entity was modified, but " + clazz + " is not indexed directly. This is proa");
    }

    private void updateBecauseOfContained(Object containingEntity) {
        Class<Object> clazz = this.getIntrospector().getClass(containingEntity);
        PojoIndexedTypeWorkPlan<?, ?, ?> delegate = this.getOrCreateIndexedDelegateForContainedUpdate(clazz);
        delegate.updateBecauseOfContained(containingEntity);
    }
}

