/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.dirtiness.building.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.AbstractPojoImplicitReindexingResolverNodeBuilder;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.AbstractPojoImplicitReindexingResolverTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoImplicitReindexingResolverCastedTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoImplicitReindexingResolverOriginalTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.dirtiness.impl.PojoImplicitReindexingResolverNode;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilterFactory;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Closer;

class PojoImplicitReindexingResolverValueNodeBuilderDelegate<V> {
    private final BoundPojoModelPathValueNode<?, ?, V> modelPath;
    private final PojoImplicitReindexingResolverBuildingHelper buildingHelper;
    private PojoImplicitReindexingResolverOriginalTypeNodeBuilder<V> typeNodeBuilder;
    private final Map<PojoRawTypeModel<?>, PojoImplicitReindexingResolverCastedTypeNodeBuilder<V, ?>> castedTypeNodeBuilders = new LinkedHashMap();
    private boolean frozen = false;

    PojoImplicitReindexingResolverValueNodeBuilderDelegate(BoundPojoModelPathValueNode<?, ?, V> modelPath, PojoImplicitReindexingResolverBuildingHelper buildingHelper) {
        this.modelPath = modelPath;
        this.buildingHelper = buildingHelper;
    }

    void closeOnFailure() {
        try (Closer closer = new Closer();){
            closer.push(AbstractPojoImplicitReindexingResolverNodeBuilder::closeOnFailure, this.typeNodeBuilder);
            closer.pushAll(AbstractPojoImplicitReindexingResolverNodeBuilder::closeOnFailure, this.castedTypeNodeBuilders.values());
        }
    }

    PojoTypeModel<V> getTypeModel() {
        return this.modelPath.type().getTypeModel();
    }

    <U> AbstractPojoImplicitReindexingResolverTypeNodeBuilder<V, ?> type(PojoRawTypeModel<U> targetTypeModel) {
        PojoRawTypeModel<V> valueRawTypeModel = this.getTypeModel().getRawType();
        if (valueRawTypeModel.isSubTypeOf(targetTypeModel)) {
            return this.type();
        }
        if (targetTypeModel.isSubTypeOf(valueRawTypeModel)) {
            return this.getOrCreateCastedTypeNodeBuilder(targetTypeModel);
        }
        throw new AssertionFailure("Error while building the automatic reindexing resolver at path " + this.modelPath + ": attempt to convert a reindexing resolver builder to an incorrect type;  got " + targetTypeModel + ", but a subtype of " + valueRawTypeModel + " was expected. This is very probably a bug in Hibernate Search, please report it.");
    }

    PojoImplicitReindexingResolverOriginalTypeNodeBuilder<V> type() {
        if (this.typeNodeBuilder == null) {
            this.checkNotFrozen();
            this.typeNodeBuilder = new PojoImplicitReindexingResolverOriginalTypeNodeBuilder<V>(this.modelPath.type(), this.buildingHelper);
        }
        return this.typeNodeBuilder;
    }

    void freeze(Set<PojoModelPathValueNode> dirtyPathsTriggeringReindexingCollector) {
        this.checkNotFrozen();
        if (!this.frozen) {
            this.frozen = true;
            if (this.typeNodeBuilder != null) {
                this.typeNodeBuilder.freeze();
                dirtyPathsTriggeringReindexingCollector.addAll(this.typeNodeBuilder.getDirtyPathsTriggeringReindexingIncludingNestedNodes());
            }
            for (PojoImplicitReindexingResolverCastedTypeNodeBuilder<V, ?> builder : this.castedTypeNodeBuilders.values()) {
                builder.freeze();
                dirtyPathsTriggeringReindexingCollector.addAll(builder.getDirtyPathsTriggeringReindexingIncludingNestedNodes());
            }
        }
    }

    <S> Collection<PojoImplicitReindexingResolverNode<V, S>> buildTypeNodes(PojoPathFilterFactory<S> pathFilterFactory, Set<PojoModelPathValueNode> allPotentialDirtyPaths) {
        this.checkFrozen();
        ArrayList<PojoImplicitReindexingResolverNode<V, S>> immutableTypeNodes = new ArrayList<PojoImplicitReindexingResolverNode<V, S>>();
        if (this.typeNodeBuilder != null) {
            this.typeNodeBuilder.build(pathFilterFactory, allPotentialDirtyPaths).ifPresent(immutableTypeNodes::add);
        }
        this.castedTypeNodeBuilders.values().stream().map(builder -> builder.build(pathFilterFactory, allPotentialDirtyPaths)).filter(Optional::isPresent).map(Optional::get).forEach(immutableTypeNodes::add);
        return immutableTypeNodes;
    }

    private void checkNotFrozen() {
        if (this.frozen) {
            throw new AssertionFailure("A mutating method was called on " + this + " after it was frozen. There is a bug in Hibernate Search, please report it.");
        }
    }

    final void checkFrozen() {
        if (!this.frozen) {
            throw new AssertionFailure("A method was called on " + this + " before it was frozen, but a preliminary freeze is required. There is a bug in Hibernate Search, please report it.");
        }
    }

    private <U> PojoImplicitReindexingResolverCastedTypeNodeBuilder<V, U> getOrCreateCastedTypeNodeBuilder(PojoRawTypeModel<U> targetTypeModel) {
        return this.castedTypeNodeBuilders.computeIfAbsent(targetTypeModel, this::createCastedTypeNodeBuilder);
    }

    private <U> PojoImplicitReindexingResolverCastedTypeNodeBuilder<V, U> createCastedTypeNodeBuilder(PojoRawTypeModel<U> targetTypeModel) {
        this.checkNotFrozen();
        return new PojoImplicitReindexingResolverCastedTypeNodeBuilder<V, U>(this.modelPath.castedType(targetTypeModel), this.buildingHelper);
    }
}

