/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl;

import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingConfigurationCollector;
import org.hibernate.search.engine.mapper.mapping.spi.MappingBuildContext;
import org.hibernate.search.mapper.pojo.bridge.RoutingKeyBridge;
import org.hibernate.search.mapper.pojo.bridge.TypeBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.BeanBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.RoutingKeyBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.TypeBinder;
import org.hibernate.search.mapper.pojo.mapping.building.spi.ErrorCollectingPojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMappingCollectorTypeNode;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.TypeMappingStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl.InitialPropertyMappingStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl.RoutingKeyBridgeMappingContributor;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl.TypeBridgeMappingContributor;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingConfigurationContributor;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.spi.PojoAdditionalMetadataCollectorTypeNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.reporting.impl.PojoEventContexts;

public class TypeMappingStepImpl
implements TypeMappingStep,
PojoMappingConfigurationContributor,
PojoTypeMetadataContributor {
    private final PojoRawTypeModel<?> typeModel;
    private String backendName;
    private String indexName;
    private final ErrorCollectingPojoTypeMetadataContributor children = new ErrorCollectingPojoTypeMetadataContributor();

    public TypeMappingStepImpl(PojoRawTypeModel<?> typeModel) {
        this.typeModel = typeModel;
    }

    @Override
    public void configure(MappingBuildContext buildContext, MappingConfigurationCollector<PojoTypeMetadataContributor> configurationCollector) {
        if (this.indexName != null) {
            try {
                configurationCollector.mapToIndex(this.typeModel, this.backendName, this.indexName);
            }
            catch (RuntimeException e) {
                buildContext.getFailureCollector().withContext(PojoEventContexts.fromType(this.typeModel)).add((Throwable)e);
            }
        }
        configurationCollector.collectContributor(this.typeModel, (Object)this);
    }

    @Override
    public void contributeAdditionalMetadata(PojoAdditionalMetadataCollectorTypeNode collector) {
        this.children.contributeAdditionalMetadata(collector);
    }

    @Override
    public void contributeMapping(PojoMappingCollectorTypeNode collector) {
        this.children.contributeMapping(collector);
    }

    @Override
    public TypeMappingStep indexed() {
        return this.indexed(this.typeModel.getJavaClass().getName());
    }

    @Override
    public TypeMappingStep indexed(String indexName) {
        this.indexName = indexName;
        return this;
    }

    @Override
    public TypeMappingStep indexed(String backendName, String indexName) {
        this.backendName = backendName;
        this.indexName = indexName;
        return this;
    }

    @Override
    public TypeMappingStep routingKeyBridge(Class<? extends RoutingKeyBridge> bridgeClass) {
        return this.routingKeyBridge((BeanReference<? extends RoutingKeyBridge>)BeanReference.of(bridgeClass));
    }

    @Override
    public TypeMappingStep routingKeyBridge(BeanReference<? extends RoutingKeyBridge> bridgeReference) {
        return this.routingKeyBinder(new BeanBinder(bridgeReference));
    }

    @Override
    public TypeMappingStep routingKeyBinder(RoutingKeyBinder<?> binder) {
        this.children.add(new RoutingKeyBridgeMappingContributor(binder));
        return this;
    }

    @Override
    public TypeMappingStep bridge(Class<? extends TypeBridge> bridgeClass) {
        return this.bridge((BeanReference<? extends TypeBridge>)BeanReference.of(bridgeClass));
    }

    @Override
    public TypeMappingStep bridge(BeanReference<? extends TypeBridge> bridgeReference) {
        return this.binder(new BeanBinder(bridgeReference));
    }

    @Override
    public TypeMappingStep binder(TypeBinder<?> binder) {
        this.children.add(new TypeBridgeMappingContributor(binder));
        return this;
    }

    @Override
    public PropertyMappingStep property(String propertyName) {
        PojoPropertyModel<?> propertyModel = this.typeModel.getProperty(propertyName);
        InitialPropertyMappingStep child = new InitialPropertyMappingStep(this, propertyModel);
        this.children.add(child);
        return child;
    }
}

