/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;
import org.hibernate.search.mapper.pojo.work.impl.PojoTypeDocumentWorkExecutor;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContextProvider;
import org.hibernate.search.mapper.pojo.work.spi.PojoSessionWorkExecutor;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoSessionWorkExecutorImpl
implements PojoSessionWorkExecutor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoWorkIndexedTypeContextProvider indexedTypeContextProvider;
    private final AbstractPojoSessionContextImplementor sessionContext;
    private final PojoRuntimeIntrospector introspector;
    private final DocumentCommitStrategy commitStrategy;
    private final Map<Class<?>, PojoTypeDocumentWorkExecutor<?, ?, ?>> typeExecutors = new HashMap();

    public PojoSessionWorkExecutorImpl(PojoWorkIndexedTypeContextProvider indexedTypeContextProvider, AbstractPojoSessionContextImplementor sessionContext, DocumentCommitStrategy commitStrategy) {
        this.indexedTypeContextProvider = indexedTypeContextProvider;
        this.sessionContext = sessionContext;
        this.introspector = sessionContext.getRuntimeIntrospector();
        this.commitStrategy = commitStrategy;
    }

    @Override
    public CompletableFuture<?> add(Object entity) {
        return this.add(null, entity);
    }

    @Override
    public CompletableFuture<?> add(Object providedId, Object entity) {
        Class<Object> clazz = this.introspector.getClass(entity);
        PojoTypeDocumentWorkExecutor<?, ?, ?> typeExecutor = this.typeExecutors.get(clazz);
        if (typeExecutor == null) {
            typeExecutor = this.createTypeDocumentExecutor(clazz);
            this.typeExecutors.put(clazz, typeExecutor);
        }
        return typeExecutor.add(providedId, entity);
    }

    private PojoTypeDocumentWorkExecutor<?, ?, ?> createTypeDocumentExecutor(Class<?> clazz) {
        Optional<PojoWorkIndexedTypeContext<?, ?, ?>> typeContext = this.indexedTypeContextProvider.getByExactClass(clazz);
        if (!typeContext.isPresent()) {
            throw log.notDirectlyIndexedType(clazz);
        }
        return typeContext.get().createDocumentWorkExecutor(this.sessionContext, this.commitStrategy);
    }
}

