/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.binding.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEntityBindingContext;
import org.hibernate.search.mapper.pojo.bridge.RoutingKeyBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.RoutingKeyBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.AbstractCompositeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.BoundRoutingKeyBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.RoutingKeyBinder;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.PojoModelType;
import org.hibernate.search.mapper.pojo.model.dependency.PojoTypeIndexingDependencyConfigurationContext;
import org.hibernate.search.mapper.pojo.model.dependency.impl.PojoTypeIndexingDependencyConfigurationContextImpl;
import org.hibernate.search.mapper.pojo.model.impl.PojoModelTypeRootElement;
import org.hibernate.search.util.common.impl.AbstractCloser;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class RoutingKeyBindingContextImpl<T>
extends AbstractCompositeBindingContext
implements RoutingKeyBindingContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexedEntityBindingContext indexedEntityBindingContext;
    private final PojoModelTypeRootElement<T> bridgedElement;
    private final PojoTypeIndexingDependencyConfigurationContextImpl<T> dependencyContext;
    private PartialBinding<T> partialBinding;

    public RoutingKeyBindingContextImpl(BeanResolver beanResolver, IndexedEntityBindingContext indexedEntityBindingContext, PojoModelTypeRootElement<T> bridgedElement, PojoTypeIndexingDependencyConfigurationContextImpl<T> dependencyContext) {
        super(beanResolver);
        this.indexedEntityBindingContext = indexedEntityBindingContext;
        this.bridgedElement = bridgedElement;
        this.dependencyContext = dependencyContext;
    }

    @Override
    public void setBridge(RoutingKeyBridge bridge) {
        this.setBridge((BeanHolder<RoutingKeyBridge>)BeanHolder.of((Object)bridge));
    }

    @Override
    public void setBridge(BeanHolder<? extends RoutingKeyBridge> bridgeHolder) {
        this.partialBinding = new PartialBinding(bridgeHolder);
    }

    @Override
    public PojoModelType getBridgedElement() {
        return this.bridgedElement;
    }

    @Override
    public PojoTypeIndexingDependencyConfigurationContext getDependencies() {
        return this.dependencyContext;
    }

    public BoundRoutingKeyBridge<T> applyBinder(RoutingKeyBinder binder) {
        try {
            binder.bind(this);
            if (this.partialBinding == null) {
                throw log.missingBridgeForBinder(binder);
            }
            RoutingKeyBindingContextImpl.checkBridgeDependencies(this.bridgedElement, this.dependencyContext);
            BoundRoutingKeyBridge<T> boundRoutingKeyBridge = this.partialBinding.complete(this.indexedEntityBindingContext, this.bridgedElement, this.dependencyContext);
            return boundRoutingKeyBridge;
        }
        catch (RuntimeException e) {
            if (this.partialBinding != null) {
                this.partialBinding.abort((AbstractCloser<?, ?>)new SuppressingCloser((Throwable)e));
            }
            throw e;
        }
        finally {
            this.partialBinding = null;
        }
    }

    private static class PartialBinding<T> {
        private final BeanHolder<? extends RoutingKeyBridge> bridgeHolder;

        private PartialBinding(BeanHolder<? extends RoutingKeyBridge> bridgeHolder) {
            this.bridgeHolder = bridgeHolder;
        }

        void abort(AbstractCloser<?, ?> closer) {
            closer.push(holder -> ((RoutingKeyBridge)holder.get()).close(), this.bridgeHolder);
            closer.push(BeanHolder::close, this.bridgeHolder);
        }

        BoundRoutingKeyBridge<T> complete(IndexedEntityBindingContext indexedEntityBindingContext, PojoModelTypeRootElement<T> bridgedElement, PojoTypeIndexingDependencyConfigurationContextImpl<T> dependencyContext) {
            indexedEntityBindingContext.explicitRouting();
            return new BoundRoutingKeyBridge<T>(this.bridgeHolder, bridgedElement, dependencyContext);
        }
    }
}

