/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.binding.impl;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaElement;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactory;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexBindingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexSchemaContributionListener;
import org.hibernate.search.mapper.pojo.bridge.TypeBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.TypeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.AbstractCompositeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.BoundTypeBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.PojoIndexSchemaContributionListener;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.TypeBinder;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.PojoModelType;
import org.hibernate.search.mapper.pojo.model.dependency.PojoTypeIndexingDependencyConfigurationContext;
import org.hibernate.search.mapper.pojo.model.dependency.impl.PojoTypeIndexingDependencyConfigurationContextImpl;
import org.hibernate.search.mapper.pojo.model.impl.PojoModelTypeRootElement;
import org.hibernate.search.util.common.impl.AbstractCloser;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class TypeBindingContextImpl<T>
extends AbstractCompositeBindingContext
implements TypeBindingContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoModelTypeRootElement<T> bridgedElement;
    private final PojoTypeIndexingDependencyConfigurationContextImpl<T> dependencyContext;
    private final IndexFieldTypeFactory indexFieldTypeFactory;
    private final PojoIndexSchemaContributionListener listener;
    private final IndexSchemaElement indexSchemaElement;
    private PartialBinding<T> partialBinding;

    public TypeBindingContextImpl(BeanResolver beanResolver, IndexBindingContext indexBindingContext, PojoModelTypeRootElement<T> bridgedElement, PojoTypeIndexingDependencyConfigurationContextImpl<T> dependencyContext) {
        super(beanResolver);
        this.bridgedElement = bridgedElement;
        this.dependencyContext = dependencyContext;
        this.indexFieldTypeFactory = indexBindingContext.createTypeFactory();
        this.listener = new PojoIndexSchemaContributionListener();
        this.indexSchemaElement = indexBindingContext.getSchemaElement((IndexSchemaContributionListener)this.listener);
    }

    @Override
    public void setBridge(TypeBridge bridge) {
        this.setBridge((BeanHolder<TypeBridge>)BeanHolder.of((Object)bridge));
    }

    @Override
    public void setBridge(BeanHolder<? extends TypeBridge> bridgeHolder) {
        this.partialBinding = new PartialBinding(bridgeHolder);
    }

    @Override
    public PojoModelType getBridgedElement() {
        return this.bridgedElement;
    }

    @Override
    public PojoTypeIndexingDependencyConfigurationContext getDependencies() {
        return this.dependencyContext;
    }

    @Override
    public IndexFieldTypeFactory getTypeFactory() {
        return this.indexFieldTypeFactory;
    }

    @Override
    public IndexSchemaElement getIndexSchemaElement() {
        return this.indexSchemaElement;
    }

    public Optional<BoundTypeBridge<T>> applyBinder(TypeBinder binder) {
        try {
            binder.bind(this);
            if (this.partialBinding == null) {
                throw log.missingBridgeForBinder(binder);
            }
            TypeBindingContextImpl.checkBridgeDependencies(this.bridgedElement, this.dependencyContext);
            if (!this.listener.isAnySchemaContributed()) {
                try (Object closer = new Closer();){
                    this.partialBinding.abort((AbstractCloser<?, ?>)closer);
                }
                closer = Optional.empty();
                return closer;
            }
            Optional<BoundTypeBridge<T>> closer = Optional.of(this.partialBinding.complete(this.bridgedElement, this.dependencyContext));
            return closer;
        }
        catch (RuntimeException e) {
            if (this.partialBinding != null) {
                this.partialBinding.abort((AbstractCloser<?, ?>)new SuppressingCloser((Throwable)e));
            }
            throw e;
        }
        finally {
            this.partialBinding = null;
        }
    }

    private static class PartialBinding<T> {
        private final BeanHolder<? extends TypeBridge> bridgeHolder;

        private PartialBinding(BeanHolder<? extends TypeBridge> bridgeHolder) {
            this.bridgeHolder = bridgeHolder;
        }

        void abort(AbstractCloser<?, ?> closer) {
            closer.push(holder -> ((TypeBridge)holder.get()).close(), this.bridgeHolder);
            closer.push(BeanHolder::close, this.bridgeHolder);
        }

        BoundTypeBridge<T> complete(PojoModelTypeRootElement<T> bridgedElement, PojoTypeIndexingDependencyConfigurationContextImpl<T> dependencyContext) {
            return new BoundTypeBridge<T>(this.bridgeHolder, bridgedElement, dependencyContext);
        }
    }
}

