/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.util.function.Function;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.ValueBindingContext;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.ValueBinder;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeFromIndexedValueContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;
import org.hibernate.search.util.common.impl.Contracts;

public final class PassThroughValueBridge<F>
implements ValueBridge<F, F> {
    private final Class<F> fieldType;
    private final Function<String, F> parsingFunction;

    private PassThroughValueBridge(Class<F> fieldType, Function<String, F> parsingFunction) {
        Contracts.assertNotNull(fieldType, (String)"fieldType");
        this.fieldType = fieldType;
        this.parsingFunction = parsingFunction;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.fieldType.getName() + "]";
    }

    @Override
    public F toIndexedValue(F value, ValueBridgeToIndexedValueContext context) {
        return value;
    }

    @Override
    public F fromIndexedValue(F value, ValueBridgeFromIndexedValueContext context) {
        return value;
    }

    @Override
    public F parse(String value) {
        return this.parsingFunction.apply(value);
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        PassThroughValueBridge castedOther = (PassThroughValueBridge)other;
        return this.fieldType.equals(castedOther.fieldType);
    }

    public static class Binder<F>
    implements ValueBinder {
        private final Class<F> rawValueType;
        private final ValueBridge<F, F> bridge;

        public Binder(Class<F> rawValueType, Function<String, F> parsingFunction) {
            this.rawValueType = rawValueType;
            this.bridge = new PassThroughValueBridge(rawValueType, parsingFunction);
        }

        @Override
        public void bind(ValueBindingContext<?> context) {
            context.setBridge(this.rawValueType, BeanHolder.of(this.bridge), context.getTypeFactory().as(this.rawValueType));
        }
    }
}

