/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.impl;

import java.util.Collection;
import org.hibernate.search.engine.common.spi.ErrorHandler;
import org.hibernate.search.mapper.pojo.mapping.context.spi.AbstractPojoBackendMappingContext;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeManagerContainer;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManagerContainer;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.mapper.pojo.scope.impl.PojoScopeDelegateImpl;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeDelegate;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeTypeExtendedContextProvider;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoBackendSessionContext;
import org.hibernate.search.mapper.pojo.session.impl.PojoSearchSessionDelegateImpl;
import org.hibernate.search.mapper.pojo.session.spi.PojoSearchSessionDelegate;
import org.hibernate.search.util.common.impl.Closer;

public class PojoMappingDelegateImpl
implements PojoMappingDelegate {
    private final ErrorHandler errorHandler;
    private final PojoIndexedTypeManagerContainer indexedTypeManagers;
    private final PojoContainedTypeManagerContainer containedTypeManagers;

    public PojoMappingDelegateImpl(ErrorHandler errorHandler, PojoIndexedTypeManagerContainer indexedTypeManagers, PojoContainedTypeManagerContainer containedTypeManagers) {
        this.errorHandler = errorHandler;
        this.indexedTypeManagers = indexedTypeManagers;
        this.containedTypeManagers = containedTypeManagers;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.pushAll(PojoIndexedTypeManager::close, this.indexedTypeManagers.getAll());
            closer.pushAll(PojoContainedTypeManager::close, this.containedTypeManagers.getAll());
        }
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public <R, E, E2, C> PojoScopeDelegate<R, E2, C> createPojoScope(AbstractPojoBackendMappingContext mappingContext, Collection<? extends Class<? extends E>> targetedTypes, PojoScopeTypeExtendedContextProvider<E, C> indexedTypeExtendedContextProvider) {
        return PojoScopeDelegateImpl.create(mappingContext, this.indexedTypeManagers, this.containedTypeManagers, targetedTypes, indexedTypeExtendedContextProvider);
    }

    @Override
    public PojoSearchSessionDelegate createSearchSessionDelegate(AbstractPojoBackendSessionContext backendSessionContext) {
        return new PojoSearchSessionDelegateImpl(this.indexedTypeManagers, this.containedTypeManagers, backendSessionContext);
    }
}

