/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoTypeAdditionalMetadataBuilder;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.spi.PojoAdditionalMetadataCollectorIndexedTypeNode;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoIndexedTypeAdditionalMetadata;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class PojoIndexedTypeAdditionalMetadataBuilder
implements PojoAdditionalMetadataCollectorIndexedTypeNode {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoTypeAdditionalMetadataBuilder rootBuilder;
    private final Optional<String> backendName;
    private final Optional<String> indexName;

    PojoIndexedTypeAdditionalMetadataBuilder(PojoTypeAdditionalMetadataBuilder rootBuilder, Optional<String> backendName, Optional<String> indexName) {
        this.rootBuilder = rootBuilder;
        this.backendName = backendName;
        this.indexName = indexName;
    }

    @Override
    public ContextualFailureCollector getFailureCollector() {
        return this.rootBuilder.getFailureCollector();
    }

    void checkSameIndex(Optional<String> backendName, Optional<String> indexName) {
        if (this.backendName.equals(backendName) && this.indexName.equals(indexName)) {
            return;
        }
        throw log.multipleIndexMapping(this.backendName, this.indexName, backendName, indexName);
    }

    public PojoIndexedTypeAdditionalMetadata build() {
        return new PojoIndexedTypeAdditionalMetadata(this.backendName, this.indexName);
    }
}

