/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexer;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoBackendSessionContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;

public class PojoTypeIndexer<I, E, D extends DocumentElement> {
    private final AbstractPojoBackendSessionContext sessionContext;
    private final PojoWorkIndexedTypeContext<I, E, D> typeContext;
    private final IndexIndexer<D> delegate;

    public PojoTypeIndexer(PojoWorkIndexedTypeContext<I, E, D> typeContext, AbstractPojoBackendSessionContext sessionContext, IndexIndexer<D> delegate) {
        this.sessionContext = sessionContext;
        this.typeContext = typeContext;
        this.delegate = delegate;
    }

    CompletableFuture<?> add(Object providedId, Object entity) {
        Supplier<E> entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        I identifier = this.typeContext.getIdentifierMapping().getIdentifier(providedId, entitySupplier);
        DocumentReferenceProvider referenceProvider = this.typeContext.toDocumentReferenceProvider(this.sessionContext, identifier, entitySupplier);
        return this.delegate.add(referenceProvider, this.typeContext.toDocumentContributor(entitySupplier, this.sessionContext));
    }
}

