/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.search.util.common.impl.Throwables;

public final class Futures {
    private Futures() {
    }

    public static <T> CompletableFuture<T> create(Supplier<CompletableFuture<T>> initiator) {
        return CompletableFuture.completedFuture(null).thenCompose(ignored -> (CompletableFuture)initiator.get());
    }

    public static <T> Function<Throwable, T> handler(Function<Throwable, T> delegate) {
        return throwable -> {
            if (throwable instanceof CompletionException) {
                throwable = throwable.getCause();
            }
            return delegate.apply((Throwable)throwable);
        };
    }

    public static <T, R> BiFunction<T, Throwable, R> handler(BiFunction<T, Throwable, R> delegate) {
        return (result, throwable) -> {
            if (throwable instanceof CompletionException) {
                throwable = throwable.getCause();
            }
            return delegate.apply((Object)result, (Throwable)throwable);
        };
    }

    public static <T> BiConsumer<T, Throwable> handler(BiConsumer<T, Throwable> delegate) {
        return (result, throwable) -> {
            if (throwable instanceof CompletionException) {
                throwable = throwable.getCause();
            }
            delegate.accept((Object)result, (Throwable)throwable);
        };
    }

    public static <T> BiConsumer<T, Throwable> copyHandler(CompletableFuture<T> copyFuture) {
        return (result, throwable) -> {
            if (throwable != null) {
                copyFuture.completeExceptionally((Throwable)throwable);
            } else {
                copyFuture.complete(result);
            }
        };
    }

    public static <T, R> Function<T, CompletionStage<R>> safeComposer(Function<? super T, ? extends CompletionStage<R>> delegate) {
        return result -> {
            try {
                return (CompletionStage)delegate.apply(result);
            }
            catch (Throwable t) {
                CompletableFuture future = new CompletableFuture();
                future.completeExceptionally(t);
                return future;
            }
        };
    }

    public static <T> CompletableFuture<T> whenCompleteExecute(CompletableFuture<?> self, Supplier<? extends CompletionStage<T>> action) {
        return ((CompletableFuture)self.handle(Futures.handler((T result, Throwable throwable) -> throwable))).thenCompose(throwable -> {
            CompletableFuture<Object> stage;
            try {
                stage = (CompletableFuture<Object>)action.get();
            }
            catch (Throwable otherThrowable2) {
                CompletableFuture<Object> future = new CompletableFuture<Object>();
                future.completeExceptionally(otherThrowable2);
                stage = future;
            }
            if (throwable != null) {
                return stage.handle(Futures.handler((T ignored, Throwable otherThrowable) -> {
                    throw Futures.wrap(Throwables.combine(throwable, otherThrowable));
                }));
            }
            return stage;
        });
    }

    public static <T> T unwrappedExceptionJoin(CompletableFuture<T> future) {
        try {
            return future.join();
        }
        catch (CompletionException e) {
            throw Throwables.expectRuntimeException(e.getCause());
        }
    }

    private static RuntimeException wrap(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        return new CompletionException(throwable);
    }
}

