/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.reflect.impl;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.hibernate.search.util.common.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

public final class MethodValueReadHandle<T>
implements ValueReadHandle<T> {
    private static final Log log = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final Method method;

    public MethodValueReadHandle(Method method) {
        this.method = method;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.method + "]";
    }

    @Override
    public T get(Object thiz) {
        try {
            return (T)this.method.invoke(thiz, new Object[0]);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw log.errorInvokingMember(this.method, thiz, e);
        }
    }

    @Override
    public int hashCode() {
        return this.method.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        MethodValueReadHandle other = (MethodValueReadHandle)obj;
        return this.method.equals(other.method);
    }
}

