/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.reflect.spi;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;

public abstract class AbstractTypeOrdering<T> {
    protected AbstractTypeOrdering() {
    }

    public Stream<? extends T> getAscendingSuperTypes(T subType) {
        LinkedHashSet result = new LinkedHashSet();
        this.collectSuperTypesAscending(result, subType);
        return result.stream();
    }

    public Stream<? extends T> getDescendingSuperTypes(T subType) {
        LinkedHashSet result = new LinkedHashSet();
        this.collectSuperTypesDescending(result, subType);
        return result.stream();
    }

    protected abstract T getSuperClass(T var1);

    protected abstract Stream<T> getDeclaredInterfaces(T var1);

    private void collectSuperTypesAscending(Set<T> result, T subType) {
        if (subType == null) {
            return;
        }
        if (!result.add(subType)) {
            return;
        }
        this.getDeclaredInterfaces(subType).forEach(interfaze -> this.collectSuperTypesAscending(result, interfaze));
        this.collectSuperTypesAscending(result, this.getSuperClass(subType));
    }

    private void collectSuperTypesDescending(Set<T> result, T subType) {
        if (subType == null) {
            return;
        }
        if (result.contains(subType)) {
            return;
        }
        this.collectSuperTypesDescending(result, this.getSuperClass(subType));
        this.getDeclaredInterfaces(subType).forEach(interfaze -> this.collectSuperTypesDescending(result, interfaze));
        result.add(subType);
    }
}

