/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.reporting;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.hibernate.search.util.common.reporting.EventContextElement;
import org.hibernate.search.util.common.reporting.impl.CommonEventContextMessages;

public final class EventContext {
    private static final CommonEventContextMessages MESSAGES = CommonEventContextMessages.INSTANCE;
    private final EventContext parent;
    private final EventContextElement element;

    public static EventContext create(EventContextElement firstElement, EventContextElement ... otherElements) {
        EventContext result = new EventContext(null, firstElement);
        for (EventContextElement otherElement : otherElements) {
            result = new EventContext(result, otherElement);
        }
        return result;
    }

    public static EventContext concat(EventContext first, EventContext ... others) {
        EventContext result = first;
        for (EventContext other : others) {
            result = first.append(other);
        }
        return result;
    }

    private EventContext(EventContext parent, EventContextElement element) {
        this.parent = parent;
        this.element = element;
    }

    public String toString() {
        return this.getClass() + "[" + this.render() + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        EventContext other = (EventContext)obj;
        return Objects.equals(this.parent, other.parent) && this.element.equals(other.element);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.element);
    }

    public List<EventContextElement> getElements() {
        ArrayList<EventContextElement> result = new ArrayList<EventContextElement>();
        this.addTo(result);
        return result;
    }

    public String render() {
        StringJoiner contextJoiner = new StringJoiner(MESSAGES.contextSeparator());
        for (EventContextElement element : this.getElements()) {
            contextJoiner.add(element.render());
        }
        return contextJoiner.toString();
    }

    public String renderWithPrefix() {
        return MESSAGES.contextPrefix() + this.render();
    }

    public EventContext append(EventContext other) {
        return other.appendTo(this);
    }

    private EventContext appendTo(EventContext other) {
        EventContext result = other;
        if (this.parent != null) {
            result = this.parent.appendTo(result);
        }
        result = new EventContext(result, this.element);
        return result;
    }

    private void addTo(List<EventContextElement> list) {
        if (this.parent != null) {
            this.parent.addTo(list);
        }
        list.add(this.element);
    }
}

