/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.logging.impl;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.CommonMiscLog;
import org.hibernate.search.util.common.logging.impl.TypeFormatter;
import org.jboss.logging.Logger;

public class CommonMiscLog_$logger
implements CommonMiscLog,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = CommonMiscLog_$logger.class.getName();
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;

    public CommonMiscLog_$logger(Logger log) {
        this.log = log;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String mustNotBeNull$str() {
        return "HSEARCH900000: '%1$s' must not be null.";
    }

    @Override
    public final IllegalArgumentException mustNotBeNull(String objectDescription) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mustNotBeNull$str(), objectDescription));
        CommonMiscLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String collectionMustNotBeNullNorEmpty$str() {
        return "HSEARCH900001: '%1$s' must not be null or empty.";
    }

    @Override
    public final IllegalArgumentException collectionMustNotBeNullNorEmpty(String objectDescription) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.collectionMustNotBeNullNorEmpty$str(), objectDescription));
        CommonMiscLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mustBePositiveOrZero$str() {
        return "HSEARCH900002: '%1$s' must be positive or zero.";
    }

    @Override
    public final IllegalArgumentException mustBePositiveOrZero(String objectDescription) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mustBePositiveOrZero$str(), objectDescription));
        CommonMiscLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String stringMustNotBeNullNorEmpty$str() {
        return "HSEARCH900003: '%1$s' must not be null or empty.";
    }

    @Override
    public final IllegalArgumentException stringMustNotBeNullNorEmpty(String objectDescription) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.stringMustNotBeNullNorEmpty$str(), objectDescription));
        CommonMiscLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String arrayMustNotBeNullNorEmpty$str() {
        return "HSEARCH900004: '%1$s' must not be null or empty.";
    }

    @Override
    public final IllegalArgumentException arrayMustNotBeNullNorEmpty(String objectDescription) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.arrayMustNotBeNullNorEmpty$str(), objectDescription));
        CommonMiscLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorInvokingMember$str() {
        return "HSEARCH900005: Exception while invoking '%1$s' on '%2$s': %3$s.";
    }

    @Override
    public final SearchException errorInvokingMember(Member member, String componentAsString, Throwable cause, String causeMessage) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.errorInvokingMember$str(), member, componentAsString, causeMessage), cause);
        CommonMiscLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotRequestTypeParameterOfUnparameterizedType$str() {
        return "HSEARCH900006: Requested type argument %3$s to type %2$s in implementing type %1$s, but %2$s doesn't declare any type parameter.";
    }

    @Override
    public final IllegalArgumentException cannotRequestTypeParameterOfUnparameterizedType(Type type, Class<?> rawSuperType, int typeArgumentIndex) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotRequestTypeParameterOfUnparameterizedType$str(), new TypeFormatter(type), new ClassFormatter(rawSuperType), typeArgumentIndex));
        CommonMiscLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String typeParameterIndexOutOfBound$str() {
        return "HSEARCH900007: Requested type argument %3$s to type %2$s in implementing type %1$s, but %2$s only declares %4$s type parameter(s).";
    }

    @Override
    public final IllegalArgumentException typeParameterIndexOutOfBound(Type type, Class<?> rawSuperType, int typeArgumentIndex, int typeParametersLength) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.typeParameterIndexOutOfBound$str(), new TypeFormatter(type), new ClassFormatter(rawSuperType), typeArgumentIndex, typeParametersLength));
        CommonMiscLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidTypeParameterIndex$str() {
        return "HSEARCH900008: Requested type argument index %3$s to type %2$s in implementing type %1$s should be 0 or greater.";
    }

    @Override
    public final IllegalArgumentException invalidTypeParameterIndex(Type type, Class<?> rawSuperType, int typeArgumentIndex) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidTypeParameterIndex$str(), new TypeFormatter(type), new ClassFormatter(rawSuperType), typeArgumentIndex));
        CommonMiscLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void cannotAccessRepeateableContainingAnnotationValue(Class<?> containingAnnotationType, Throwable e) {
        this.log.logf(FQCN, Logger.Level.INFO, e, this.cannotAccessRepeateableContainingAnnotationValue$str(), (Object)new ClassFormatter(containingAnnotationType));
    }

    protected String cannotAccessRepeateableContainingAnnotationValue$str() {
        return "HSEARCH900009: Unable to access the value of containing annotation '%1$s'. Ignoring annotation.";
    }

    protected String mustBeStrictlyPositive$str() {
        return "HSEARCH900010: '%1$s' must be strictly positive.";
    }

    @Override
    public final IllegalArgumentException mustBeStrictlyPositive(String objectDescription) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mustBeStrictlyPositive$str(), objectDescription));
        CommonMiscLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String collectionMustNotContainNullElement$str() {
        return "HSEARCH900011: '%1$s' must not contain any null element.";
    }

    @Override
    public final IllegalArgumentException collectionMustNotContainNullElement(String collectionDescription) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.collectionMustNotContainNullElement$str(), collectionDescription));
        CommonMiscLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorInvokingStaticMember$str() {
        return "HSEARCH900012: Exception while invoking '%1$s' with arguments %2$s: %3$s";
    }

    @Override
    public final SearchException errorInvokingStaticMember(Member member, String argumentsAsString, Throwable cause, String causeMessage) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.errorInvokingStaticMember$str(), member, argumentsAsString, causeMessage), cause);
        CommonMiscLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorAccessingJandexIndex$str() {
        return "HSEARCH900013: Exception while accessing Jandex index for '%1$s': %2$s";
    }

    @Override
    public final SearchException errorAccessingJandexIndex(URL codeSourceLocation, String message, Throwable e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.errorAccessingJandexIndex$str(), codeSourceLocation, message), e);
        CommonMiscLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorBuildingJandexIndex$str() {
        return "HSEARCH900014: Exception while building Jandex index for '%1$s': %2$s";
    }

    @Override
    public final SearchException errorBuildingJandexIndex(URL codeSourceLocation, String message, Throwable e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.errorBuildingJandexIndex$str(), codeSourceLocation, message), e);
        CommonMiscLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotOpenCodeSourceFileSystem$str() {
        return "HSEARCH900016: Cannot open filesystem for code source at '%1$s': %2$s";
    }

    @Override
    public final IOException cannotOpenCodeSourceFileSystem(URL url, String causeMessage, Throwable e) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.cannotOpenCodeSourceFileSystem$str(), url, causeMessage), e);
        CommonMiscLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotInterpretCodeSourceUrl$str() {
        return "HSEARCH900017: Cannot interpret '%1$s' as a local directory or JAR.";
    }

    @Override
    public final IOException cannotInterpretCodeSourceUrl(URL url) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.cannotInterpretCodeSourceUrl$str(), url));
        CommonMiscLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotOpenNestedJar$str() {
        return "HSEARCH900018: Cannot open a ZIP filesystem for code source at '%1$s', because the URI points to content inside a nested JAR. Run your application on JDK13+ to get nested JAR support, or disable JAR scanning by setting a mapping configurer that calls .discoverAnnotatedTypesFromRootMappingAnnotations(false). See the reference documentation for information about mapping configurers.";
    }

    @Override
    public final SearchException cannotOpenNestedJar(URI uri, Throwable e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotOpenNestedJar$str(), uri), e);
        CommonMiscLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void metaInfVersionBadStructure(Path path) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.metaInfVersionBadStructure$str(), (Object)path);
    }

    protected String metaInfVersionBadStructure$str() {
        return "HSEARCH900019: Unexpected structure for META-INF/versions entry: %s";
    }

    @Override
    public final void metaInfVersionParsingFailed(Path path, Throwable e) {
        this.log.logf(FQCN, Logger.Level.DEBUG, e, this.metaInfVersionParsingFailed$str(), (Object)path);
    }

    protected String metaInfVersionParsingFailed$str() {
        return "HSEARCH900020: Failed to parse META-INF/versions entry: %s";
    }

    @Override
    public final void cancellingCompletableFuture(CompletableFuture<?> future, boolean mayInterruptIfRunning) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.cancellingCompletableFuture$str(), future, (Object)mayInterruptIfRunning);
    }

    protected String cancellingCompletableFuture$str() {
        return "HSEARCH900021: Cancelling CompletableFuture %s (mayInterruptIfRunning = %s)";
    }

    @Override
    public final void cancellingFuture(Future<?> future, boolean mayInterruptIfRunning) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.cancellingFuture$str(), future, (Object)mayInterruptIfRunning);
    }

    protected String cancellingFuture$str() {
        return "HSEARCH900022: Cancelling Future %s (mayInterruptIfRunning = %s)";
    }

    @Override
    public final void cancellingFutureFailed(Future<?> future, boolean mayInterruptIfRunning) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.cancellingFutureFailed$str(), future, (Object)mayInterruptIfRunning);
    }

    protected String cancellingFutureFailed$str() {
        return "HSEARCH900023: Could not cancel Future %s (mayInterruptIfRunning = %s)";
    }
}

