/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.reflect.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.hibernate.search.util.common.impl.Throwables;
import org.hibernate.search.util.common.logging.impl.CommonMiscLog;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

public final class MethodValueReadHandle<T>
implements ValueReadHandle<T> {
    private final Method method;

    public MethodValueReadHandle(Method method) {
        this.method = method;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.method) + "]";
    }

    @Override
    public T get(Object thiz) {
        try {
            return (T)this.method.invoke(thiz, new Object[0]);
        }
        catch (IllegalAccessException | RuntimeException e) {
            throw CommonMiscLog.INSTANCE.errorInvokingMember(this.method, Throwables.safeToString(e, thiz), e, e.getMessage());
        }
        catch (InvocationTargetException e) {
            Throwable thrown = e.getCause();
            if (thrown instanceof Error) {
                throw (Error)thrown;
            }
            throw CommonMiscLog.INSTANCE.errorInvokingMember(this.method, Throwables.safeToString(thrown, thiz), thrown, thrown.getMessage());
        }
    }

    @Override
    public int hashCode() {
        return this.method.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        MethodValueReadHandle other = (MethodValueReadHandle)obj;
        return this.method.equals(other.method);
    }
}

