/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.hibernate.search.engine.search.predicate.dsl.PhrasePredicateFieldMoreStep;
import org.hibernate.search.engine.search.predicate.dsl.PhrasePredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.query.dsl.PhraseTermination;
import org.hibernate.search.query.dsl.impl.AbstractConnectedMultiFieldsQueryBuilder;
import org.hibernate.search.query.dsl.impl.FieldContext;
import org.hibernate.search.query.dsl.impl.FieldsContext;
import org.hibernate.search.query.dsl.impl.PhraseQueryContext;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;

public class ConnectedMultiFieldsPhraseQueryBuilder
extends AbstractConnectedMultiFieldsQueryBuilder<PhraseTermination, PhrasePredicateOptionsStep<?>>
implements PhraseTermination {
    private final PhraseQueryContext phraseContext;

    public ConnectedMultiFieldsPhraseQueryBuilder(QueryBuildingContext queryContext, QueryCustomizer queryCustomizer, FieldsContext fieldsContext, PhraseQueryContext phraseContext) {
        super(queryContext, queryCustomizer, fieldsContext);
        this.phraseContext = phraseContext;
    }

    @Override
    protected PhrasePredicateOptionsStep<?> createPredicate(SearchPredicateFactory factory, FieldContext fieldContext) {
        PhrasePredicateOptionsStep optionsStep = ((PhrasePredicateFieldMoreStep)fieldContext.applyBoost(factory.phrase().field(fieldContext.getField()))).matching(this.phraseContext.getSentence());
        optionsStep = optionsStep.slop(this.phraseContext.getSlop());
        if (fieldContext.skipAnalysis()) {
            optionsStep = optionsStep.skipAnalysis();
        } else {
            String overriddenAnalyzer = this.queryContext.getOverriddenAnalyzer(fieldContext.getField());
            if (overriddenAnalyzer != null) {
                optionsStep = optionsStep.analyzer(overriddenAnalyzer);
            }
        }
        return optionsStep;
    }
}

