package org.hibernate.search.util.logging.impl;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import org.jboss.logging.BasicLogger;
import java.util.Collection;
import org.hibernate.search.util.logging.impl.BaseHibernateSearchLogger;
import java.lang.Class;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2024-01-24T14:31:27+0000")
public class Log_$logger extends DelegatingBasicLogger implements Log, org.hibernate.search.util.logging.impl.BaseHibernateSearchLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String notAnIndexedType$str() {
        return "HSEARCH000109: %1$s is not an indexed type";
    }
    @Override
    public final IllegalArgumentException notAnIndexedType(final String entityName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), notAnIndexedType$str(), entityName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String nullIsInvalidIndexedType$str() {
        return "HSEARCH000110: 'null' is not a valid indexed type";
    }
    @Override
    public final IllegalArgumentException nullIsInvalidIndexedType() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullIsInvalidIndexedType$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getNullSessionPassedToFullTextSessionCreationException$str() {
        return "HSEARCH000178: Unable to create a FullTextSession from a null Session";
    }
    @Override
    public final IllegalArgumentException getNullSessionPassedToFullTextSessionCreationException() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getNullSessionPassedToFullTextSessionCreationException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getNullEntityManagerPassedToFullEntityManagerCreationException$str() {
        return "HSEARCH000179: Unable to create a FullTextEntityManager from a null EntityManager";
    }
    @Override
    public final IllegalArgumentException getNullEntityManagerPassedToFullEntityManagerCreationException() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getNullEntityManagerPassedToFullEntityManagerCreationException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incorrectEditDistance$str() {
        return "HSEARCH000201: The edit distance must be either 1 or 2";
    }
    @Override
    public final SearchException incorrectEditDistance() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), incorrectEditDistance$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String booleanQueryWithoutClauses$str() {
        return "HSEARCH000227: A BooleanQuery is not valid without at least one clause. Use at least one of should(Query) or must(Query).";
    }
    @Override
    public final SearchException booleanQueryWithoutClauses() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), booleanQueryWithoutClauses$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String rangeQueryWithNullToAndFromValue$str() {
        return "HSEARCH000237: Cannot create numeric range query for field '%s', since from and to values are null";
    }
    @Override
    public final SearchException rangeQueryWithNullToAndFromValue(final String fieldName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), rangeQueryWithNullToAndFromValue$str(), fieldName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String numericRangeQueryWithNonNumericToAndFromValues$str() {
        return "HSEARCH000238: Cannot create numeric range query for field '%s', since values are not numeric (Date, int, long, short or double)";
    }
    @Override
    public final SearchException numericRangeQueryWithNonNumericToAndFromValues(final String fieldName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), numericRangeQueryWithNonNumericToAndFromValues$str(), fieldName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedParameterTypeForRangeFaceting$str() {
        return "HSEARCH000269: '%1$s' is not a supported type for a range faceting request parameter. Supported types are: '%2$s'";
    }
    @Override
    public final SearchException unsupportedParameterTypeForRangeFaceting(final String facetRangeParameterType, final String supportedTypes) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unsupportedParameterTypeForRangeFaceting$str(), facetRangeParameterType, supportedTypes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noStartOrEndSpecifiedForRangeQuery$str() {
        return "HSEARCH000270: At least one of the facets ranges in facet request '%1$s' contains neither start nor end value";
    }
    @Override
    public final SearchException noStartOrEndSpecifiedForRangeQuery(final String facetRequestName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noStartOrEndSpecifiedForRangeQuery$str(), facetRequestName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String rangeDefinitionOrderRequestedForDiscreteFacetRequest$str() {
        return "HSEARCH000271: RANGE_DEFINITION_ORDER is not a valid sort order for a discrete faceting request.";
    }
    @Override
    public final SearchException rangeDefinitionOrderRequestedForDiscreteFacetRequest() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), rangeDefinitionOrderRequestedForDiscreteFacetRequest$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedProjectionConstant$str() {
        return "HSEARCH000317: Projection constant '%s' is not supported for this query.";
    }
    @Override
    public final SearchException unexpectedProjectionConstant(final String constantName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unexpectedProjectionConstant$str(), constantName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void fileDeleteFailureIgnored(final IOException e) {
        super.log.logf(FQCN, DEBUG, e, fileDeleteFailureIgnored$str());
    }
    protected String fileDeleteFailureIgnored$str() {
        return "HSEARCH000336: A file could not be deleted: likely lock contention. Not a problem for index replications as it will be attempted again in the future.";
    }
    protected String cannotReferenceAnalyzerAndNormalizer$str() {
        return "HSEARCH000342: Field '%1$s' refers to both an analyzer and a normalizer.";
    }
    @Override
    public final SearchException cannotReferenceAnalyzerAndNormalizer(final String relativeFieldPath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotReferenceAnalyzerAndNormalizer$str(), relativeFieldPath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String minimumShouldMatchConflictingConstraints$str() {
        return "HSEARCH000352: Multiple conflicting minimumShouldMatch constraints";
    }
    @Override
    public final SearchException minimumShouldMatchConflictingConstraints() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), minimumShouldMatchConflictingConstraints$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownAnalyzer$str() {
        return "HSEARCH000353: Unknown analyzer: '%1$s'. Make sure you defined this analyzer.";
    }
    @Override
    public final SearchException unknownAnalyzer(final String analyzerName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownAnalyzer$str(), analyzerName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUnwrapSearchFactory$str() {
        return "HSEARCH000400: Cannot unwrap a SearchFactory into a '%1$s'.";
    }
    @Override
    public final SearchException cannotUnwrapSearchFactory(final Class<?> cls) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUnwrapSearchFactory$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(cls)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseSetFirstResultWithScroll$str() {
        return "HSEARCH000401: Cannot use firstResult > 0 with scrolls.";
    }
    @Override
    public final SearchException cannotUseSetFirstResultWithScroll() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseSetFirstResultWithScroll$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String defaultNullTokenNotSupported$str() {
        return "HSEARCH000402: indexNullAs can no longer be set to `DEFAULT_NULL_TOKEN`. Specify a value that can be parsed into the property type (%1$s).";
    }
    @Override
    public final SearchException defaultNullTokenNotSupported(final Class<?> propertyType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), defaultNullTokenNotSupported$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(propertyType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseAnalyzerOnSortableField$str() {
        return "HSEARCH000403: Cannot apply analyzer '%1$s' on a sortable field. If you don't need an analyzer, use @Field(analyze = Analyze.NO). If you need to normalize text without tokenizing it, use a normalizer instead: @Field(normalizer = ...). If you need an actual analyzer (with tokenization), define two separate fields: one with an analyzer that is not sortable, and one with a normalizer that is sortable.";
    }
    @Override
    public final SearchException cannotUseAnalyzerOnSortableField(final String analyzerName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseAnalyzerOnSortableField$str(), analyzerName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseIndexNullAsAndAnalyzer$str() {
        return "HSEARCH000404: indexNullAs is not supported for analyzed fields. Trying to define the analyzer: '%1$s' together with indexNullAs: '%2$s'.";
    }
    @Override
    public final SearchException cannotUseIndexNullAsAndAnalyzer(final String analyzerName, final String indexNullAs) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseIndexNullAsAndAnalyzer$str(), analyzerName, indexNullAs));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToOverrideQueryAnalyzerWithMoreThanOneAnalyzerForSimpleQueryStringQueries$str() {
        return "HSEARCH000406: For simple query string queries, if one field has its analyzer overridden, all fields must have the same analyzers. You probably forgot to override the analyzer for some fields, because multiple analyzers were found: %1$s.";
    }
    @Override
    public final SearchException unableToOverrideQueryAnalyzerWithMoreThanOneAnalyzerForSimpleQueryStringQueries(final Collection<String> analyzers) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToOverrideQueryAnalyzerWithMoreThanOneAnalyzerForSimpleQueryStringQueries$str(), analyzers));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseAnalyzerOnFacetField$str() {
        return "HSEARCH000407: Cannot apply an analyzer on a faceted field. Use a normalizer instead. Analyzer: '%1$s'. If an actual analyzer (with tokenization) is necessary, define two separate fields: one with an analyzer and no corresponding @Facet, and one with a normalizer and corresponding @Facet(forField = ...).";
    }
    @Override
    public final SearchException cannotUseAnalyzerOnFacetField(final String analyzerName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseAnalyzerOnFacetField$str(), analyzerName));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
