/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.builtin.impl;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import org.hibernate.search.bridge.builtin.impl.Truncation;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeFromIndexedValueContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;

public class TruncatingDateBridge
implements ValueBridge<Date, Instant> {
    private final Truncation truncation;

    public TruncatingDateBridge(Truncation truncation) {
        this.truncation = truncation;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public Instant toIndexedValue(Date value, ValueBridgeToIndexedValueContext context) {
        if (value == null) {
            return null;
        }
        return this.truncate(Instant.ofEpochMilli(value.getTime()));
    }

    public Date fromIndexedValue(Instant value, ValueBridgeFromIndexedValueContext context) {
        return value == null ? null : Date.from(value);
    }

    public Instant parse(String value) {
        return this.truncate(ParseUtils.parseInstant((String)value));
    }

    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        return this.getClass().equals(other.getClass()) && this.truncation.equals(((TruncatingDateBridge)other).truncation);
    }

    private Instant truncate(Instant value) {
        ZonedDateTime zonedDateTime = value.atZone(ZoneOffset.UTC);
        return this.truncation.truncate(zonedDateTime).toInstant();
    }
}

