/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.search.spi.LuceneMigrationUtils;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.PredicateScoreStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.dsl.SpatialWithinPredicateOptionsStep;
import org.hibernate.search.engine.spatial.DistanceUnit;
import org.hibernate.search.query.dsl.SpatialTermination;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.query.dsl.impl.SpatialQueryContext;
import org.hibernate.search.spatial.Coordinates;

public class ConnectedSpatialQueryBuilder
implements SpatialTermination {
    private final QueryBuildingContext queryContext;
    private final QueryCustomizer queryCustomizer;
    private final SpatialQueryContext spatialContext;

    public ConnectedSpatialQueryBuilder(QueryBuildingContext queryContext, QueryCustomizer queryCustomizer, SpatialQueryContext spatialContext) {
        this.queryContext = queryContext;
        this.spatialContext = spatialContext;
        this.queryCustomizer = queryCustomizer;
    }

    @Override
    public Query createQuery() {
        return LuceneMigrationUtils.toLuceneQuery((SearchPredicate)this.createPredicate());
    }

    private SearchPredicate createPredicate() {
        SearchPredicateFactory factory = this.queryContext.getScope().predicate();
        SpatialWithinPredicateOptionsStep optionsStep = factory.spatial().within().field(this.spatialContext.getCoordinatesField()).circle(Coordinates.toGeoPoint(this.spatialContext.getCoordinates()), this.spatialContext.getRadiusDistance(), DistanceUnit.KILOMETERS);
        this.queryCustomizer.applyScoreOptions((PredicateScoreStep<?>)optionsStep);
        SearchPredicate predicate = optionsStep.toPredicate();
        return this.queryCustomizer.applyFilter(factory, predicate);
    }
}

