/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.builtin.impl;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.hibernate.search.bridge.builtin.impl.Truncation;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeFromIndexedValueContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;

public class TruncatingCalendarBridge
implements ValueBridge<Calendar, ZonedDateTime> {
    private final Truncation truncation;

    public TruncatingCalendarBridge(Truncation truncation) {
        this.truncation = truncation;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public ZonedDateTime toIndexedValue(Calendar value, ValueBridgeToIndexedValueContext context) {
        if (value == null) {
            return null;
        }
        return this.truncate(TruncatingCalendarBridge.toZonedDateTime(value));
    }

    public Calendar fromIndexedValue(ZonedDateTime value, ValueBridgeFromIndexedValueContext context) {
        return value == null ? null : TruncatingCalendarBridge.fromZonedDateTime(value);
    }

    public ZonedDateTime parse(String value) {
        return this.truncate(ParseUtils.parseZonedDateTime((String)value));
    }

    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        return this.getClass().equals(other.getClass()) && this.truncation.equals(((TruncatingCalendarBridge)other).truncation);
    }

    private ZonedDateTime truncate(ZonedDateTime value) {
        ZoneId originalZone = value.getZone();
        return this.truncation.truncate(value.withZoneSameInstant(ZoneOffset.UTC)).withZoneSameInstant(originalZone);
    }

    private static ZonedDateTime toZonedDateTime(Calendar value) {
        if (value instanceof GregorianCalendar) {
            return ((GregorianCalendar)value).toZonedDateTime();
        }
        return value.toInstant().atZone(ZoneId.of("UTC"));
    }

    private static Calendar fromZonedDateTime(ZonedDateTime value) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(value.getZone()), Locale.getDefault());
        if (calendar instanceof GregorianCalendar) {
            calendar.setTimeInMillis(Math.addExact(Math.multiplyExact(value.toEpochSecond(), 1000L), (long)value.get(ChronoField.MILLI_OF_SECOND)));
        } else {
            calendar.setTime(Date.from(value.toInstant()));
        }
        return calendar;
    }
}

