/*
 * SPDX-License-Identifier: Apache-2.0
 * Copyright Red Hat Inc. and Hibernate Authors
 */
package org.hibernate.search.util.logging.impl;

import java.lang.invoke.MethodHandles.Lookup;

import org.jboss.logging.Logger;

/**
 * A factory class for class loggers. Allows a creation of loggers after the DRY principle.
 *
 * @author Hardy Ferentschik
 * @author Sanne Grinovero
 */
public final class LoggerFactory {

	private LoggerFactory() {
		//now allowed
	}

	public static MigrationHelperLog make(Lookup creationContext) {
		return make( MigrationHelperLog.class, creationContext );
	}

	public static <T> T make(Class<T> logClass, Lookup creationContext) {
		final String className = creationContext.lookupClass().getName();
		return Logger.getMessageLogger( creationContext, logClass, className );
	}

}
