/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.logging.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.logging.impl.BaseHibernateSearchLogger;
import org.hibernate.search.util.logging.impl.MigrationHelperLog;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class MigrationHelperLog_$logger
extends DelegatingBasicLogger
implements MigrationHelperLog,
BaseHibernateSearchLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MigrationHelperLog_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public MigrationHelperLog_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String notAnIndexedType$str() {
        return "HSEARCH000109: %1$s is not an indexed type";
    }

    @Override
    public final IllegalArgumentException notAnIndexedType(String entityName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.notAnIndexedType$str(), entityName));
        MigrationHelperLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String nullIsInvalidIndexedType$str() {
        return "HSEARCH000110: 'null' is not a valid indexed type";
    }

    @Override
    public final IllegalArgumentException nullIsInvalidIndexedType() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullIsInvalidIndexedType$str(), new Object[0]));
        MigrationHelperLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToFindLongitudeOrLatitudeProperty$str() {
        return "HSEARCH000159: No property annotated with %1$s(markerSet = \"%3$s\"). There must be exactly one such property in order to map it to geo-point field '%2$s'.";
    }

    @Override
    public final SearchException unableToFindLongitudeOrLatitudeProperty(String annotation, String fieldName, String markerSet) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToFindLongitudeOrLatitudeProperty$str(), annotation, fieldName, markerSet));
        MigrationHelperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multipleLatitudeOrLongitudeProperties$str() {
        return "HSEARCH000160: Multiple properties annotated with %1$s(markerSet = \"%3$s\"). There must be exactly one such property in order to map it to geo-point field '%2$s'.";
    }

    @Override
    public final SearchException multipleLatitudeOrLongitudeProperties(String annotation, String fieldName, String markerSet) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multipleLatitudeOrLongitudeProperties$str(), annotation, fieldName, markerSet));
        MigrationHelperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String getNullSessionPassedToFullTextSessionCreationException$str() {
        return "HSEARCH000178: Unable to create a FullTextSession from a null Session";
    }

    @Override
    public final IllegalArgumentException getNullSessionPassedToFullTextSessionCreationException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.getNullSessionPassedToFullTextSessionCreationException$str(), new Object[0]));
        MigrationHelperLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String getNullEntityManagerPassedToFullEntityManagerCreationException$str() {
        return "HSEARCH000179: Unable to create a FullTextEntityManager from a null EntityManager";
    }

    @Override
    public final IllegalArgumentException getNullEntityManagerPassedToFullEntityManagerCreationException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.getNullEntityManagerPassedToFullEntityManagerCreationException$str(), new Object[0]));
        MigrationHelperLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String incorrectEditDistance$str() {
        return "HSEARCH000201: The edit distance must be either 1 or 2";
    }

    @Override
    public final SearchException incorrectEditDistance() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.incorrectEditDistance$str(), new Object[0]));
        MigrationHelperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String booleanQueryWithoutClauses$str() {
        return "HSEARCH000227: A BooleanQuery is not valid without at least one clause. Use at least one of should(Query) or must(Query).";
    }

    @Override
    public final SearchException booleanQueryWithoutClauses() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.booleanQueryWithoutClauses$str(), new Object[0]));
        MigrationHelperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String rangeQueryWithNullToAndFromValue$str() {
        return "HSEARCH000237: Cannot create numeric range query for field '%s', since from and to values are null";
    }

    @Override
    public final SearchException rangeQueryWithNullToAndFromValue(String fieldName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.rangeQueryWithNullToAndFromValue$str(), fieldName));
        MigrationHelperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String numericRangeQueryWithNonNumericToAndFromValues$str() {
        return "HSEARCH000238: Cannot create numeric range query for field '%s', since values are not numeric (Date, int, long, short or double)";
    }

    @Override
    public final SearchException numericRangeQueryWithNonNumericToAndFromValues(String fieldName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.numericRangeQueryWithNonNumericToAndFromValues$str(), fieldName));
        MigrationHelperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unsupportedParameterTypeForRangeFaceting$str() {
        return "HSEARCH000269: '%1$s' is not a supported type for a range faceting request parameter. Supported types are: '%2$s'";
    }

    @Override
    public final SearchException unsupportedParameterTypeForRangeFaceting(String facetRangeParameterType, String supportedTypes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedParameterTypeForRangeFaceting$str(), facetRangeParameterType, supportedTypes));
        MigrationHelperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noStartOrEndSpecifiedForRangeQuery$str() {
        return "HSEARCH000270: At least one of the facets ranges in facet request '%1$s' contains neither start nor end value";
    }

    @Override
    public final SearchException noStartOrEndSpecifiedForRangeQuery(String facetRequestName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noStartOrEndSpecifiedForRangeQuery$str(), facetRequestName));
        MigrationHelperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String rangeDefinitionOrderRequestedForDiscreteFacetRequest$str() {
        return "HSEARCH000271: RANGE_DEFINITION_ORDER is not a valid sort order for a discrete faceting request.";
    }

    @Override
    public final SearchException rangeDefinitionOrderRequestedForDiscreteFacetRequest() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.rangeDefinitionOrderRequestedForDiscreteFacetRequest$str(), new Object[0]));
        MigrationHelperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unexpectedProjectionConstant$str() {
        return "HSEARCH000317: Projection constant '%s' is not supported for this query.";
    }

    @Override
    public final SearchException unexpectedProjectionConstant(String constantName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedProjectionConstant$str(), constantName));
        MigrationHelperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void fileDeleteFailureIgnored(IOException e) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)e, this.fileDeleteFailureIgnored$str(), new Object[0]);
    }

    protected String fileDeleteFailureIgnored$str() {
        return "HSEARCH000336: A file could not be deleted: likely lock contention. Not a problem for index replications as it will be attempted again in the future.";
    }

    protected String cannotReferenceAnalyzerAndNormalizer$str() {
        return "HSEARCH000342: Field '%1$s' refers to both an analyzer and a normalizer.";
    }

    @Override
    public final SearchException cannotReferenceAnalyzerAndNormalizer(String relativeFieldPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotReferenceAnalyzerAndNormalizer$str(), relativeFieldPath));
        MigrationHelperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String minimumShouldMatchConflictingConstraints$str() {
        return "HSEARCH000352: Multiple conflicting minimumShouldMatch constraints";
    }

    @Override
    public final SearchException minimumShouldMatchConflictingConstraints() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.minimumShouldMatchConflictingConstraints$str(), new Object[0]));
        MigrationHelperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownAnalyzer$str() {
        return "HSEARCH000353: Unknown analyzer: '%1$s'. Make sure you defined this analyzer.";
    }

    @Override
    public final SearchException unknownAnalyzer(String analyzerName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownAnalyzer$str(), analyzerName));
        MigrationHelperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotUnwrapSearchFactory$str() {
        return "HSEARCH000400: Cannot unwrap a SearchFactory into a '%1$s'.";
    }

    @Override
    public final SearchException cannotUnwrapSearchFactory(Class<?> cls) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUnwrapSearchFactory$str(), new ClassFormatter(cls)));
        MigrationHelperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotUseSetFirstResultWithScroll$str() {
        return "HSEARCH000401: Cannot use firstResult > 0 with scrolls.";
    }

    @Override
    public final SearchException cannotUseSetFirstResultWithScroll() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseSetFirstResultWithScroll$str(), new Object[0]));
        MigrationHelperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String defaultNullTokenNotSupported$str() {
        return "HSEARCH000402: indexNullAs can no longer be set to `DEFAULT_NULL_TOKEN`. Specify a value that can be parsed into the property type (%1$s).";
    }

    @Override
    public final SearchException defaultNullTokenNotSupported(Class<?> propertyType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.defaultNullTokenNotSupported$str(), new ClassFormatter(propertyType)));
        MigrationHelperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotUseAnalyzerOnSortableField$str() {
        return "HSEARCH000403: Cannot apply analyzer '%1$s' on a sortable field. If you don't need an analyzer, use @Field(analyze = Analyze.NO). If you need to normalize text without tokenizing it, use a normalizer instead: @Field(normalizer = ...). If you need an actual analyzer (with tokenization), define two separate fields: one with an analyzer that is not sortable, and one with a normalizer that is sortable.";
    }

    @Override
    public final SearchException cannotUseAnalyzerOnSortableField(String analyzerName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseAnalyzerOnSortableField$str(), analyzerName));
        MigrationHelperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotUseIndexNullAsAndAnalyzer$str() {
        return "HSEARCH000404: indexNullAs is not supported for analyzed fields. Trying to define the analyzer: '%1$s' together with indexNullAs: '%2$s'.";
    }

    @Override
    public final SearchException cannotUseIndexNullAsAndAnalyzer(String analyzerName, String indexNullAs) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseIndexNullAsAndAnalyzer$str(), analyzerName, indexNullAs));
        MigrationHelperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToOverrideQueryAnalyzerWithMoreThanOneAnalyzerForSimpleQueryStringQueries$str() {
        return "HSEARCH000406: For simple query string queries, if one field has its analyzer overridden, all fields must have the same analyzers. You probably forgot to override the analyzer for some fields, because multiple analyzers were found: %1$s.";
    }

    @Override
    public final SearchException unableToOverrideQueryAnalyzerWithMoreThanOneAnalyzerForSimpleQueryStringQueries(Collection<String> analyzers) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToOverrideQueryAnalyzerWithMoreThanOneAnalyzerForSimpleQueryStringQueries$str(), analyzers));
        MigrationHelperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotUseAnalyzerOnFacetField$str() {
        return "HSEARCH000407: Cannot apply an analyzer on a faceted field. Use a normalizer instead. Analyzer: '%1$s'. If an actual analyzer (with tokenization) is necessary, define two separate fields: one with an analyzer and no corresponding @Facet, and one with a normalizer and corresponding @Facet(forField = ...).";
    }

    @Override
    public final SearchException cannotUseAnalyzerOnFacetField(String analyzerName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseAnalyzerOnFacetField$str(), analyzerName));
        MigrationHelperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

