/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.LuceneExtension;
import org.hibernate.search.backend.lucene.search.predicate.dsl.LuceneSearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.BooleanPredicateClausesStep;
import org.hibernate.search.engine.search.predicate.dsl.BooleanPredicateOptionsCollector;
import org.hibernate.search.engine.search.predicate.dsl.PredicateScoreStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactoryExtension;
import org.hibernate.search.query.dsl.QueryCustomization;

class QueryCustomizer
implements QueryCustomization<QueryCustomizer> {
    private float boost = 1.0f;
    private boolean constantScore;
    private Query filter;

    QueryCustomizer() {
    }

    @Override
    public QueryCustomizer boostedTo(float boost) {
        this.boost = boost * this.boost;
        return this;
    }

    @Override
    public QueryCustomizer withConstantScore() {
        this.constantScore = true;
        return this;
    }

    @Override
    public QueryCustomizer filteredBy(Query filter) {
        this.filter = filter;
        return this;
    }

    public float getBoost() {
        return this.boost;
    }

    public void applyScoreOptions(PredicateScoreStep<?> step) {
        if (this.boost != 1.0f) {
            step.boost(this.boost);
        }
        if (this.constantScore) {
            step.constantScore();
        }
    }

    public SearchPredicate applyFilter(SearchPredicateFactory factory, SearchPredicate predicate) {
        if (this.filter == null) {
            return predicate;
        }
        BooleanPredicateClausesStep step = (BooleanPredicateClausesStep)factory.bool().must(predicate);
        this.applyFilter(factory, (BooleanPredicateOptionsCollector<?>)step);
        return step.toPredicate();
    }

    public void applyFilter(SearchPredicateFactory factory, BooleanPredicateOptionsCollector<?> collector) {
        if (this.filter == null) {
            return;
        }
        collector.filter(((LuceneSearchPredicateFactory)factory.extension((SearchPredicateFactoryExtension)LuceneExtension.get())).fromLuceneQuery(this.filter));
    }
}

