/*
 * SPDX-License-Identifier: Apache-2.0
 * Copyright Red Hat Inc. and Hibernate Authors
 */
package org.hibernate.search.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.hibernate.search.annotations.impl.LongitudeAnnotationProcessor;
import org.hibernate.search.engine.environment.bean.BeanRetrieval;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.PropertyMapping;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.PropertyMappingAnnotationProcessorRef;

/**
 * Mark the property hosting the latitude of a specific spatial coordinate.
 * The property must be of type {@code Double} (or its native version).
 *
 * @hsearch.experimental Spatial support is still considered experimental
 * @author Nicolas Helleringer
 * @deprecated Use Hibernate Search 6's {@link org.hibernate.search.mapper.pojo.bridge.builtin.annotation.Longitude}
 * instead. See also the javadoc of {@link Spatial}.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ ElementType.FIELD, ElementType.METHOD })
@Documented
@Deprecated
@PropertyMapping(processor = @PropertyMappingAnnotationProcessorRef(type = LongitudeAnnotationProcessor.class,
		retrieval = BeanRetrieval.CONSTRUCTOR))
public @interface Longitude {
	/**
	 * @return the name of the spatial field (defined in @Spatial.name)
	 */
	String of() default "";
}
