/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.search.engine.search.aggregation.dsl.AggregationFinalStep;
import org.hibernate.search.engine.search.aggregation.dsl.RangeAggregationRangeMoreStep;
import org.hibernate.search.engine.search.aggregation.dsl.RangeAggregationRangeStep;
import org.hibernate.search.engine.search.aggregation.dsl.SearchAggregationFactory;
import org.hibernate.search.query.dsl.impl.FacetRange;
import org.hibernate.search.query.dsl.impl.FacetingRequestImpl;
import org.hibernate.search.query.dsl.impl.RangeFacetImpl;
import org.hibernate.search.query.engine.impl.FacetComparators;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetSortOrder;
import org.hibernate.search.util.common.data.Range;

public class RangeFacetRequest<T>
extends FacetingRequestImpl<Map<Range<T>, Long>> {
    private final List<FacetRange<T>> facetRangeList;

    RangeFacetRequest(String name, String fieldName, List<FacetRange<T>> facetRanges) {
        super(name, fieldName);
        if (facetRanges == null || facetRanges.isEmpty()) {
            throw new IllegalArgumentException("At least one facet range must be specified");
        }
        this.facetRangeList = facetRanges;
    }

    @Override
    public AggregationFinalStep<Map<Range<T>, Long>> requestAggregation(SearchAggregationFactory<?> factory) {
        RangeAggregationRangeStep rangeStep = factory.range().field(this.getFieldName(), this.getFacetValueType());
        RangeAggregationRangeMoreStep rangeMoreStep = null;
        for (FacetRange<T> facetRange : this.facetRangeList) {
            rangeMoreStep = rangeStep.range(facetRange.range());
            rangeStep = rangeMoreStep;
        }
        return rangeMoreStep;
    }

    @Override
    public List<Facet> toFacets(Map<Range<T>, Long> aggregation) {
        ArrayList<Facet> result = new ArrayList<Facet>(aggregation.size());
        for (Map.Entry<Range<T>, Long> entry : aggregation.entrySet()) {
            int facetIndex = this.findFacetRangeIndex(entry.getKey());
            int count = Math.toIntExact(entry.getValue());
            if (count == 0 && !this.includeZeroCounts) continue;
            FacetRange<T> range = this.facetRangeList.get(facetIndex);
            result.add(new RangeFacetImpl<T>(this.getFacetingName(), this.getFieldName(), range, count));
        }
        if (!this.sort.equals((Object)FacetSortOrder.RANGE_DEFINITION_ORDER)) {
            result.sort(FacetComparators.get(this.sort));
        }
        return result;
    }

    @Override
    public String toString() {
        return "RangeFacetRequest{facetRangeList=" + String.valueOf(this.facetRangeList) + "} " + super.toString();
    }

    private Class<T> getFacetValueType() {
        T o = this.facetRangeList.get(0).getMin();
        if (o == null) {
            o = this.facetRangeList.get(0).getMax();
        }
        return o.getClass();
    }

    private int findFacetRangeIndex(Range<T> range) {
        int index = 0;
        for (FacetRange<T> facetRange : this.facetRangeList) {
            if (facetRange.range().equals(range)) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

