/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.sort.impl;

import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.search.backend.lucene.LuceneExtension;
import org.hibernate.search.backend.lucene.search.sort.dsl.LuceneSearchSortFactory;
import org.hibernate.search.backend.lucene.search.spi.LuceneMigrationUtils;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.dsl.CompositeSortComponentsStep;
import org.hibernate.search.engine.search.sort.dsl.DistanceSortOptionsStep;
import org.hibernate.search.engine.search.sort.dsl.FieldSortMissingValueBehaviorStep;
import org.hibernate.search.engine.search.sort.dsl.FieldSortOptionsStep;
import org.hibernate.search.engine.search.sort.dsl.ScoreSortOptionsStep;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactory;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactoryExtension;
import org.hibernate.search.engine.search.sort.dsl.SortOrder;
import org.hibernate.search.engine.search.sort.dsl.SortOrderStep;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.util.common.SearchException;

public class SortFieldStates {
    private static final Object MISSING_VALUE_LAST = new Object();
    private static final Object MISSING_VALUE_FIRST = new Object();
    private final SearchSortFactory<?> factory;
    private final CompositeSortComponentsStep<?, ?> delegate;
    private SortField.Type currentType;
    private String currentName;
    private SortOrder currentOrder;
    private Object currentMissingValue;
    private SortField currentSortFieldNativeSortDescription;
    private Coordinates coordinates;
    private Double currentLatitude;
    private Double currentLongitude;

    public SortFieldStates(QueryBuildingContext queryContext) {
        this.factory = queryContext.getScope().sort();
        this.delegate = this.factory.composite();
    }

    public void setCurrentType(SortField.Type currentType) {
        this.currentType = currentType;
    }

    public void setCurrentName(String fieldName) {
        this.currentName = fieldName;
    }

    public void setCurrentMissingValue(Object currentMissingValue) {
        this.currentMissingValue = currentMissingValue;
    }

    public void setCurrentMissingValueLast() {
        this.currentMissingValue = MISSING_VALUE_LAST;
    }

    public void setCurrentMissingValueFirst() {
        this.currentMissingValue = MISSING_VALUE_FIRST;
    }

    public void setAsc() {
        this.currentOrder = SortOrder.ASC;
    }

    public void setDesc() {
        this.currentOrder = SortOrder.DESC;
    }

    public void setCurrentSortFieldNativeSortDescription(SortField currentSortField) {
        this.currentSortFieldNativeSortDescription = currentSortField;
    }

    public void closeSortField() {
        SearchSort sort;
        if (this.currentSortFieldNativeSortDescription != null) {
            sort = ((LuceneSearchSortFactory)this.factory.extension((SearchSortFactoryExtension)LuceneExtension.get())).fromLuceneSortField(this.currentSortFieldNativeSortDescription).toSort();
        } else if (this.currentType == SortField.Type.SCORE) {
            ScoreSortOptionsStep optionsStep = this.factory.score();
            this.applyOrder((SortOrderStep<?>)optionsStep);
            sort = optionsStep.toSort();
        } else if (this.currentType == SortField.Type.DOC) {
            sort = this.factory.indexOrder().toSort();
        } else if (this.coordinates != null || this.currentLatitude != null) {
            if (this.currentMissingValue != null) {
                throw new SearchException("Missing values substitutes are not supported for distance sorting yet");
            }
            GeoPoint center = this.coordinates != null ? Coordinates.toGeoPoint(this.coordinates) : GeoPoint.of((double)this.currentLatitude, (double)this.currentLongitude);
            DistanceSortOptionsStep optionsStep = this.factory.distance(this.currentName, center);
            this.applyOrder((SortOrderStep<?>)optionsStep);
            sort = optionsStep.toSort();
        } else {
            FieldSortOptionsStep optionsStep = this.factory.field(this.currentName);
            this.applyOrder((SortOrderStep<?>)optionsStep);
            this.applyMissing(optionsStep);
            sort = optionsStep.toSort();
        }
        this.delegate.add(sort);
        this.reset();
    }

    private void applyOrder(SortOrderStep<?> step) {
        if (this.currentOrder != null) {
            step.order(this.currentOrder);
        }
    }

    private void applyMissing(FieldSortOptionsStep<?, ?, ?> step) {
        if (this.currentMissingValue == null) {
            return;
        }
        if (this.currentMissingValue == MISSING_VALUE_LAST) {
            ((FieldSortMissingValueBehaviorStep)step.missing()).last();
        } else if (this.currentMissingValue == MISSING_VALUE_FIRST) {
            ((FieldSortMissingValueBehaviorStep)step.missing()).first();
        } else {
            ((FieldSortMissingValueBehaviorStep)step.missing()).use(this.currentMissingValue);
        }
    }

    public Sort createSort() {
        return LuceneMigrationUtils.toLuceneSort((SearchSort)this.delegate.toSort());
    }

    private void reset() {
        this.currentType = null;
        this.currentName = null;
        this.currentOrder = null;
        this.currentMissingValue = null;
        this.currentSortFieldNativeSortDescription = null;
        this.coordinates = null;
        this.currentLatitude = null;
        this.currentLongitude = null;
    }

    public void setCoordinates(Coordinates coordinates) {
        this.coordinates = coordinates;
    }

    public void setCurrentLatitude(double latitude) {
        this.currentLatitude = latitude;
    }

    public void setCurrentLongitude(double longitude) {
        this.currentLongitude = longitude;
    }
}

